/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AdminOnly
@Path(value="/bundles")
public class BundleCollectionResource {
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public BundleCollectionResource(UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @GET
    public Response get(@QueryParam(value="q") String term) {
        this.permissionEnforcer.enforcePermission(Permission.GET_OSGI_STATE);
        return Response.ok(term == null ? this.representationFactory.createOsgiBundleCollectionRepresentation() : this.representationFactory.createOsgiBundleCollectionRepresentation(term)).type("application/vnd.atl.plugins.osgi.bundles+json").build();
    }
}

