/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.osgi.Bundle;
import com.atlassian.upm.osgi.BundleAccessor;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AdminOnly
@Path(value="/bundles/{id}")
public class BundleResource {
    private final BundleAccessor bundleAccessor;
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public BundleResource(BundleAccessor bundleAccessor, UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.bundleAccessor = Objects.requireNonNull(bundleAccessor, "bundleAccessor");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @GET
    public Response get(@PathParam(value="id") long id) {
        this.permissionEnforcer.enforcePermission(Permission.GET_OSGI_STATE);
        Bundle bundle = this.bundleAccessor.getBundle(id);
        if (bundle != null) {
            return Response.ok((Object)this.representationFactory.createOsgiBundleRepresentation(bundle)).type("application/vnd.atl.plugins.osgi.bundle+json").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

