/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.pac;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceEvent;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.cache.Supplier;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.pac.MarketplaceClientManager;
import com.atlassian.upm.core.pac.ParentSoftwareClientManager;
import com.atlassian.upm.pac.MpacApplication;
import com.atlassian.upm.pac.MpacApplicationSupplier;
import com.atlassian.upm.pac.MpacParentSoftwareSupplier;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class MpacApplicationCacheManager
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpacApplicationCacheManager.class);
    private final CacheFactory cacheFactory;
    private final CachedReference<Optional<MpacApplication>> mpacAppRef;
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    private final ExecutorService executorsService;
    private final SysPersisted sysPersisted;
    private final Supplier<Optional<MpacApplication>> legacyApiSupplier;
    private final Supplier<Optional<MpacApplication>> parentSoftwareApiSupplier;
    private final MarketplaceClientManager mpacV2ClientFactory;

    public MpacApplicationCacheManager(ApplicationProperties applicationProperties, CacheFactory cacheFactory, SysPersisted sysPersisted, ParentSoftwareClientManager parentSoftwareClientManager, MarketplaceClientManager mpacV2ClientFactory, UpmHostApplicationInformation hostApplicationInformation, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.cacheFactory = Objects.requireNonNull(cacheFactory);
        this.sysPersisted = Objects.requireNonNull(sysPersisted);
        this.threadLocalDelegateExecutorFactory = Objects.requireNonNull(threadLocalDelegateExecutorFactory);
        this.mpacAppRef = this.createMpacAppRef();
        this.executorsService = Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)this.getClass().getSimpleName()));
        this.mpacV2ClientFactory = Objects.requireNonNull(mpacV2ClientFactory);
        this.parentSoftwareApiSupplier = new MpacParentSoftwareSupplier(applicationProperties, parentSoftwareClientManager, hostApplicationInformation);
        this.legacyApiSupplier = new MpacApplicationSupplier(applicationProperties, sysPersisted, mpacV2ClientFactory, hostApplicationInformation);
        this.mpacAppRef.addListener((CachedReferenceListener)new CachedReferenceListener<Optional<MpacApplication>>(){

            public void onEvict(@Nonnull CachedReferenceEvent<Optional<MpacApplication>> event) {
                MpacApplicationCacheManager.this.populateCache();
            }

            public void onSet(@Nonnull CachedReferenceEvent<Optional<MpacApplication>> event) {
            }

            public void onReset(@Nonnull CachedReferenceEvent<Optional<MpacApplication>> event) {
                MpacApplicationCacheManager.this.populateCache();
            }
        }, false);
    }

    public void populateCache() {
        ExecutorService executorService = this.threadLocalDelegateExecutorFactory.createExecutorService(this.executorsService);
        try {
            executorService.execute(() -> this.mpacAppRef.get());
        }
        catch (RejectedExecutionException e) {
            LOGGER.warn("Failed to reset MPAC cache: {}", (Object)e.getMessage());
        }
    }

    CachedReference<Optional<MpacApplication>> getCachedReference() {
        return this.mpacAppRef;
    }

    public void reset() {
        this.mpacAppRef.reset();
    }

    private CachedReference<Optional<MpacApplication>> createMpacAppRef() {
        CacheSettings settings = new CacheSettingsBuilder().expireAfterWrite(4L, TimeUnit.HOURS).local().build();
        return this.cacheFactory.getCachedReference("app", this.createSupplier(), settings);
    }

    private Supplier<Optional<MpacApplication>> createSupplier() {
        return () -> {
            if (this.sysPersisted.is(UpmSettings.PAC_DISABLED)) {
                return Optional.empty();
            }
            if (this.isUsingParentSoftwareApi()) {
                return (Optional)this.parentSoftwareApiSupplier.get();
            }
            return (Optional)this.legacyApiSupplier.get();
        };
    }

    public boolean isUsingParentSoftwareApi() {
        if (Sys.isUsingParentSoftwareApi()) {
            return true;
        }
        try {
            this.mpacV2ClientFactory.getMarketplaceClient().applications();
            return false;
        }
        catch (MpacException e) {
            LOGGER.warn("Applications API unavailable, falling back to ParentSoftware : {}", (Object)e.getMessage(), (Object)e);
            return true;
        }
    }

    public void destroy() {
        this.executorsService.shutdown();
    }
}

