/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.pac;

import com.atlassian.cache.Supplier;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.ApplicationVersionSpecifier;
import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.ApplicationKeyUtils;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.pac.MarketplaceClientManager;
import com.atlassian.upm.pac.MpacApplication;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MpacApplicationSupplier
implements Supplier<Optional<MpacApplication>> {
    private final ApplicationProperties applicationProperties;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SysPersisted sysPersisted;
    private final MarketplaceClientManager mpacV2ClientFactory;
    private final UpmHostApplicationInformation hostApplicationInformation;

    public MpacApplicationSupplier(ApplicationProperties applicationProperties, SysPersisted sysPersisted, MarketplaceClientManager mpacV2ClientFactory, UpmHostApplicationInformation hostApplicationInformation) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.sysPersisted = Objects.requireNonNull(sysPersisted);
        this.mpacV2ClientFactory = Objects.requireNonNull(mpacV2ClientFactory);
        this.hostApplicationInformation = Objects.requireNonNull(hostApplicationInformation);
    }

    private <A> Option<A> fetchMpacAppInfo(ApplicationVersionSpecifier q, Function<Option<ApplicationVersion>, Option<A>> found) {
        try {
            return found.apply(UpmFugueConverters.toUpmOption(this.mpacV2ClientFactory.getMarketplaceClient().applications().safeGetVersion(this.getMarketplaceApplicationKey(), q)));
        }
        catch (Exception e) {
            this.logger.warn("Error when querying application info from MPAC : {}" + e.getMessage(), (Throwable)e);
            return Option.none();
        }
    }

    private Option<MpacApplication> fetchMpacAppInfoForLatest() {
        if (this.hostApplicationInformation.isDevelopmentProductVersion()) {
            return this.fetchMpacAppInfo(ApplicationVersionSpecifier.latest(), this.toMpacInfo(true));
        }
        return Option.none();
    }

    private Option<MpacApplication> fetchMpacAppInfoForLocalBuild() {
        return this.fetchMpacAppInfo(ApplicationVersionSpecifier.buildNumber(this.hostApplicationInformation.getBuildNumber()), this.toMpacInfo(false));
    }

    private ApplicationKey getMarketplaceApplicationKey() {
        return ApplicationKey.valueOf(ApplicationKeyUtils.getMarketplaceApplicationKey(this.applicationProperties.getDisplayName()));
    }

    private Function<Option<ApplicationVersion>, Option<MpacApplication>> toMpacInfo(boolean unknown) {
        return applicationVersion -> {
            Iterator iterator = applicationVersion.iterator();
            if (iterator.hasNext()) {
                ApplicationVersion av = (ApplicationVersion)iterator.next();
                return Option.some(new MpacApplication(unknown, av.getBuildNumber()));
            }
            if (!this.hostApplicationInformation.isDevelopmentProductVersion()) {
                return Option.some(new MpacApplication(true, null));
            }
            return Option.none();
        };
    }

    public Optional<MpacApplication> get() {
        if (this.sysPersisted.is(UpmSettings.PAC_DISABLED)) {
            return Optional.empty();
        }
        Option<MpacApplication> value = this.fetchMpacAppInfoForLocalBuild().orElse(this::fetchMpacAppInfoForLatest);
        return value.isDefined() ? Optional.of(value.get()) : Optional.empty();
    }
}

