/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.request.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.UpmUriEscaper;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.request.PluginRequest;
import com.atlassian.upm.request.PluginRequestStore;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.Objects;

@SystemAdminOnly
@Path(value="/requests/{pluginKey}/{userKey}")
public class PluginRequestResource {
    private final PermissionEnforcer permissionEnforcer;
    private final PluginRequestStore requestStore;
    private final UpmRepresentationFactory representationFactory;

    @Inject
    public PluginRequestResource(PermissionEnforcer permissionEnforcer, PluginRequestStore requestManager, UpmRepresentationFactory representationFactory) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.requestStore = Objects.requireNonNull(requestManager, "requestManager");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response getRequest(@PathParam(value="pluginKey") PathSegment pluginKeyPath, @PathParam(value="userKey") String userKey) {
        this.permissionEnforcer.enforcePermission(Permission.GET_PLUGIN_REQUESTS);
        String pluginKey = UpmUriEscaper.unescape(pluginKeyPath.getPath());
        Iterator<PluginRequest> iterator = this.requestStore.getRequest(pluginKey, new UserKey(userKey)).iterator();
        if (iterator.hasNext()) {
            PluginRequest request = iterator.next();
            return Response.ok((Object)this.representationFactory.createPluginRequestRepresentation(request)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

