/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.request.rest.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmSettings;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@LicensedOnly
@Path(value="/requests-status")
public class PluginRequestStatusResource {
    private final SysPersisted sysPersisted;

    @Inject
    public PluginRequestStatusResource(SysPersisted sysPersisted) {
        this.sysPersisted = Objects.requireNonNull(sysPersisted, "sysPersisted");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response getPluginRequestDisablement() {
        return Response.ok((Object)new PluginRequestDisabledRepresentation(this.sysPersisted.is(UpmSettings.REQUESTS_DISABLED))).build();
    }

    public static final class PluginRequestDisabledRepresentation {
        @JsonProperty
        private boolean disabled;

        @JsonCreator
        public PluginRequestDisabledRepresentation(@JsonProperty(value="disabled") boolean disabled) {
            this.disabled = disabled;
        }

        public boolean isDisabled() {
            return this.disabled;
        }
    }
}

