/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest;

import com.atlassian.marketplace.client.api.AddonQuery;
import com.atlassian.upm.api.util.Option;

public enum UpmMarketplaceFilter {
    FEATURED,
    HIGHEST_RATED,
    TOP_GROSSING,
    MOST_POPULAR,
    TRENDING,
    BY_ATLASSIAN,
    RECENTLY_UPDATED,
    TOP_VENDOR;


    public AddonQuery.View getMarketplaceView() {
        switch (this.ordinal()) {
            case 0: {
                return AddonQuery.View.FEATURED;
            }
            case 1: {
                return AddonQuery.View.HIGHEST_RATED;
            }
            case 2: {
                return AddonQuery.View.TOP_GROSSING;
            }
            case 3: {
                return AddonQuery.View.POPULAR;
            }
            case 4: {
                return AddonQuery.View.TRENDING;
            }
            case 5: {
                return AddonQuery.View.BY_ATLASSIAN;
            }
            case 7: {
                return AddonQuery.View.TOP_VENDOR;
            }
        }
        return AddonQuery.View.RECENTLY_UPDATED;
    }

    public String getKey() {
        switch (this.ordinal()) {
            case 0: {
                return "featured";
            }
            case 1: {
                return "highest-rated";
            }
            case 2: {
                return "top-grossing";
            }
            case 3: {
                return "popular";
            }
            case 4: {
                return "trending";
            }
            case 5: {
                return "atlassian";
            }
            case 7: {
                return "top-vendor";
            }
        }
        return "recent";
    }

    public static Option<UpmMarketplaceFilter> fromKey(String key) {
        for (UpmMarketplaceFilter f : UpmMarketplaceFilter.values()) {
            if (!f.getKey().equalsIgnoreCase(key)) continue;
            return Option.some(f);
        }
        return Option.none();
    }

    public String getLinkRel() {
        switch (this.ordinal()) {
            case 0: {
                return "featured";
            }
            case 1: {
                return "highest-rated";
            }
            case 2: {
                return "top-grossing";
            }
            case 3: {
                return "popular";
            }
            case 4: {
                return "trending";
            }
            case 5: {
                return "atlassian";
            }
            case 7: {
                return "top-vendor";
            }
        }
        return "available";
    }
}

