/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.upm.core.rest.UpmUriEscaper;
import com.atlassian.upm.mac.HamletClient;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
@Path(value="/{pluginKey}/license/crossgrade")
public class AppCrossgradeResource {
    private static final Logger log = LoggerFactory.getLogger(AppCrossgradeResource.class);
    private final HamletClient hamletClient;
    private final UpmRepresentationFactory representationFactory;

    @Inject
    public AppCrossgradeResource(HamletClient hamletClient, UpmRepresentationFactory representationFactory) {
        this.hamletClient = Objects.requireNonNull(hamletClient, "hamletClient");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
    }

    @POST
    @Produces(value={"application/json"})
    public Response getLicense(@PathParam(value="pluginKey") PathSegment pluginKeyPath) {
        String pluginKey = UpmUriEscaper.unescape(pluginKeyPath.getPath());
        try {
            return this.hamletClient.crossgradeAppLicense(pluginKey).map(uri -> Response.ok((Object)new AppCrossgradeRepresentation((URI)uri)).build()).getOrElse(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createI18nErrorRepresentation("upm.plugin.license.error.crossgrade")).type("application/vnd.atl.plugins.error+json").build());
        }
        catch (Exception e) {
            log.error("Error crossgrading license for " + pluginKey, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.representationFactory.createI18nErrorRepresentation("upm.plugin.license.error.crossgrade")).type("application/vnd.atl.plugins.error+json").build();
        }
    }

    private static class AppCrossgradeRepresentation {
        @JsonProperty
        private final URI hamletCrossgradeUri;

        @JsonCreator
        public AppCrossgradeRepresentation(@JsonProperty(value="hamletCrossgradeUri") URI hamletCrossgradeUri) {
            this.hamletCrossgradeUri = hamletCrossgradeUri;
        }
    }
}

