/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.api.util.Either;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.UpmUriEscaper;
import com.atlassian.upm.core.rest.resources.RequestContext;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.AddonMarketplaceQueries;
import com.atlassian.upm.pac.AvailableAddonWithVersion;
import com.atlassian.upm.request.PluginRequestStore;
import com.atlassian.upm.rest.UpmMarketplaceFilter;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Path(value="/available/{key}")
@WebSudoNotRequired
public class AvailablePluginOrPluginCollectionResource {
    private final UpmRepresentationFactory factory;
    private final PermissionEnforcer permissionEnforcer;
    private final PluginRequestStore pluginRequestStore;
    private final UserManager userManager;
    private final AddonMarketplaceQueries mpacQueries;

    @Inject
    public AvailablePluginOrPluginCollectionResource(UpmRepresentationFactory factory, PermissionEnforcer permissionEnforcer, PluginRequestStore pluginRequestStore, UserManager userManager, AddonMarketplaceQueries mpacQueries) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.factory = Objects.requireNonNull(factory, "factory");
        this.pluginRequestStore = Objects.requireNonNull(pluginRequestStore, "pluginRequestStore");
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.mpacQueries = Objects.requireNonNull(mpacQueries, "mpacQueries");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.available+json"})
    public Response get(@PathParam(value="key") PathSegment keySegment, @QueryParam(value="q") String q, @QueryParam(value="category") String category, @QueryParam(value="cost") String cost, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @Context HttpServletRequest request) throws MpacException {
        String key = keySegment.getPath();
        this.permissionEnforcer.enforcePermission(Permission.GET_AVAILABLE_PLUGINS);
        Either r = UpmMarketplaceFilter.fromKey(key).fold(() -> {
            try {
                Iterator<AvailableAddonWithVersion> iterator = this.mpacQueries.getClient().getAvailablePlugin(UpmUriEscaper.unescape(key)).iterator();
                if (iterator.hasNext()) {
                    AvailableAddonWithVersion a = iterator.next();
                    return Either.right(Response.ok((Object)this.factory.createAvailablePluginRepresentation(a.getAddon(), a.getVersion())).build());
                }
            }
            catch (MpacException e) {
                return Either.left(e);
            }
            return Either.right(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }, filter -> {
            Option<String> searchText = Option.option(StringUtils.trimToNull(q));
            AddonMarketplaceQueries.AvailableAddonSummaries result = this.mpacQueries.getAvailableAddonSummaries(filter.getMarketplaceView(), offset, category, cost, searchText);
            return Either.right(Response.ok((Object)this.factory.createAvailablePluginCollectionRepresentation(result.addons, result.sourceAddons, this.pluginRequestStore.getRequestsByUser(this.userManager.getRemoteUserKey()), new RequestContext(request).pacUnreachable(result.mpacUnreachable), (UpmMarketplaceFilter)((Object)filter), searchText)).build());
        });
        Iterator iterator = r.left().iterator();
        if (iterator.hasNext()) {
            MpacException e = (MpacException)iterator.next();
            throw e;
        }
        return (Response)r.right().get();
    }
}

