/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@LicensedOnly
@Path(value="/product-version")
@WebSudoNotRequired
public class ProductVersionResource {
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;
    private final PacClient client;
    private final UpmHostApplicationInformation hostApplicationInformation;

    @Inject
    public ProductVersionResource(UpmRepresentationFactory factory, PacClient client, PermissionEnforcer permissionEnforcer, UpmHostApplicationInformation hostApplicationInformation) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.representationFactory = Objects.requireNonNull(factory, "representationFactory");
        this.client = Objects.requireNonNull(client, "client");
        this.hostApplicationInformation = Objects.requireNonNull(hostApplicationInformation, "hostApplicationInformation");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get() {
        this.permissionEnforcer.enforcePermission(Permission.GET_AVAILABLE_PLUGINS);
        return Response.ok((Object)this.representationFactory.createProductVersionRepresentation(this.hostApplicationInformation.isDevelopmentProductVersion(), this.client.isUnknownProductVersion().getOrElse(false))).build();
    }
}

