/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.core.SelfUpdateController;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@WebSudoNotRequired
@SystemAdminOnly
@Path(value="/self-update-completed")
public class SelfUpdateCompletionResource {
    private final PermissionEnforcer permissionEnforcer;
    private final SelfUpdateController selfUpdateController;

    @Inject
    public SelfUpdateCompletionResource(PermissionEnforcer permissionEnforcer, SelfUpdateController selfUpdateController) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.selfUpdateController = Objects.requireNonNull(selfUpdateController, "selfUpdateController");
    }

    @SystemAdminOnly
    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get() {
        this.permissionEnforcer.enforceSystemAdmin();
        return Response.ok((Object)new SelfUpdateCompletionStateRepresentation(this.selfUpdateController.isCleanupNeeded())).build();
    }

    @AnonymousSiteAccess
    @POST
    @XsrfProtectionExcluded
    public Response post() {
        if (this.selfUpdateController.cleanupAfterSelfUpdate()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public static final class SelfUpdateCompletionStateRepresentation {
        @JsonProperty
        private Boolean cleanupNeeded;

        @JsonCreator
        public SelfUpdateCompletionStateRepresentation(@JsonProperty(value="cleanupNeeded") Boolean cleanupNeeded) {
            this.cleanupNeeded = cleanupNeeded;
        }

        public Boolean isCleanupNeeded() {
            return this.cleanupNeeded;
        }
    }
}

