/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.api.config;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.signing.api.Certificate;
import com.atlassian.upm.signing.api.PluginInstallationOrigin;
import com.atlassian.upm.signing.api.config.UpmConfigBuilder;
import com.atlassian.upm.signing.api.config.UpmConfigPathChecker;
import com.atlassian.upm.signing.api.config.UpmConfigStatus;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpmConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpmConfig.class);
    public static final Predicate<Path> CERTIFICATE_FILE_FILTER = p -> Files.isRegularFile(p, new LinkOption[0]) && Files.isReadable(p) && !p.toString().endsWith(".properties");
    private final Path upmConfigurationFile;
    private final Path truststorePath;
    private final String checkInterval;
    private final Map<String, String> sysPropsConfig;
    private final UpmConfigPathChecker pathChecker;
    private boolean logOnLoadProperties = true;

    @Deprecated
    public UpmConfig(ApplicationProperties applicationProperties) {
        this(UpmConfigBuilder.builder(applicationProperties));
    }

    private UpmConfig(UpmConfigBuilder properties) {
        this(properties.getConfigFilePath(), properties.getTrustStorePath(), properties.isLooseCheck());
    }

    UpmConfig(Path upmConfigurationFilePath, Path upmTruststorePath, boolean isDevMode) {
        this.upmConfigurationFile = upmConfigurationFilePath;
        this.truststorePath = upmTruststorePath;
        this.sysPropsConfig = UpmConfig.systemPropertiesConfiguration();
        this.checkInterval = this.loadPropertiesOrGetDefaults().get("atlassian.upm.signature.check.interval");
        UpmConfigPathChecker upmConfigPathChecker = this.pathChecker = isDevMode ? new UpmConfigPathChecker.LooseUpmConfigPathChecker() : new UpmConfigPathChecker();
        if (LOGGER.isDebugEnabled()) {
            String configFileExists = Files.exists(this.upmConfigurationFile, new LinkOption[0]) ? "existing" : "";
            LOGGER.debug("Using {}UpmConfigFile : {}", (Object)configFileExists, (Object)this.upmConfigurationFile.toFile().getAbsolutePath());
            String trustStoreExists = Files.exists(this.truststorePath, new LinkOption[0]) ? "existing" : "";
            LOGGER.debug("Using {}TrustStore : {}", (Object)trustStoreExists, (Object)this.truststorePath.toFile().getAbsolutePath());
        }
    }

    private Map<String, String> loadPropertiesOrGetDefaults() {
        Properties properties = new Properties();
        if (this.loadUncheckedProperties(properties)) {
            return UpmConfig.readConfiguration(properties);
        }
        return this.sysPropsConfig;
    }

    private boolean loadUncheckedProperties(Properties properties) {
        if (this.configurationFileExists()) {
            boolean bl;
            FileInputStream in = new FileInputStream(this.upmConfigurationFile.toFile());
            try {
                properties.load(in);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error reading UPM Config file " + String.valueOf(this.upmConfigurationFile), e);
                }
            }
            ((InputStream)in).close();
            return bl;
        }
        return false;
    }

    private Map<String, String> loadProperties() {
        Properties properties = new Properties();
        boolean configFileExists = this.loadUncheckedProperties(properties);
        if (configFileExists) {
            UpmConfigStatus status = this.configFileStatus();
            if (status.success()) {
                if (this.logOnLoadProperties) {
                    LOGGER.info("UPM configuration loaded from {}, safety check ok", (Object)this.upmConfigurationFile);
                }
                this.logOnLoadProperties = false;
                return UpmConfig.readConfiguration(properties);
            }
            LOGGER.error("UPM configuration Safety Check failed : {}", (Object)status.description());
            return Map.of();
        }
        if (this.logOnLoadProperties && LOGGER.isInfoEnabled()) {
            boolean disabled = Boolean.parseBoolean(this.sysPropsConfig.get("atlassian.upm.signature.check.disabled"));
            LOGGER.info("UPM Config file {} does not exist : using default/sysProps configuration. Plugin Signing will be {}", (Object)this.upmConfigurationFile, (Object)(disabled ? "disabled" : "enabled"));
            this.logOnLoadProperties = false;
        }
        return this.sysPropsConfig;
    }

    public Path getTruststorePath() {
        return this.truststorePath;
    }

    public Path getConfigFile() {
        return this.upmConfigurationFile;
    }

    public UpmConfigStatus configFileStatus() {
        if (Files.exists(this.upmConfigurationFile, new LinkOption[0])) {
            return this.pathChecker.checkFile(this.upmConfigurationFile);
        }
        return UpmConfigStatus.builder().build();
    }

    public UpmConfigStatus trustStoreStatus() {
        if (!this.isPluginSigningEnabled()) {
            return UpmConfigStatus.builder().build();
        }
        if (!Files.exists(this.truststorePath, new LinkOption[0])) {
            return UpmConfigStatus.builder().withStatus(UpmConfigStatus.Status.FAILURE).withI18nKey("upm.config.check.truststore.absent").withDescription("UPM truststore does not exist!").build();
        }
        if (!Files.isDirectory(this.truststorePath, new LinkOption[0])) {
            return UpmConfigStatus.builder().withStatus(UpmConfigStatus.Status.FAILURE).withI18nKey("upm.config.check.truststore.invalid").withDescription("UPM truststore is not a directory!").build();
        }
        UpmConfigStatus status = this.pathChecker.checkFile(this.truststorePath);
        if (status.success()) {
            List<Path> certificates = this.getCertificatesPaths();
            if (certificates.isEmpty()) {
                return UpmConfigStatus.builder().withStatus(UpmConfigStatus.Status.FAILURE).withI18nKey("upm.config.check.truststore.empty").withDescription("UPM truststore is empty!").build();
            }
            for (Path certificate : certificates) {
                status = status.merge(this.pathChecker.checkFile(certificate));
            }
        }
        return status;
    }

    public boolean safetyCheck() {
        UpmConfigStatus status = this.safetyCheckStatus();
        if (status.getStatus() == UpmConfigStatus.Status.SUCCESS) {
            LOGGER.info(status.getDescription());
        } else {
            LOGGER.warn(status.getDescription());
        }
        return status.getStatus() != UpmConfigStatus.Status.FAILURE;
    }

    public UpmConfigStatus safetyCheckStatus() {
        return this.configFileStatus().merge(this.trustStoreStatus());
    }

    private boolean isExistingDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean configurationFileExists() {
        return this.upmConfigurationFile != null && Files.exists(this.upmConfigurationFile, new LinkOption[0]);
    }

    public boolean isConfigured() {
        return this.configurationFileExists();
    }

    public boolean hasTruststore() {
        return this.isExistingDirectory(this.truststorePath);
    }

    private List<Path> getCertificatesPaths() {
        if (this.hasTruststore()) {
            List<Path> list;
            block9: {
                Stream<Path> certs = Files.list(this.truststorePath);
                try {
                    list = certs.filter(CERTIFICATE_FILE_FILTER).toList();
                    if (certs == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (certs != null) {
                            try {
                                certs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        LOGGER.warn("Failed to list certificates files from {}", (Object)this.truststorePath);
                    }
                }
                certs.close();
            }
            return list;
        }
        return List.of();
    }

    public boolean hasCertificates() {
        return !this.getCertificatesPaths().isEmpty();
    }

    public boolean isPluginSigningEnabled() {
        return this.isPluginSigningEnabled(this.loadProperties());
    }

    public boolean isPluginSigningEnabled(PluginInstallationOrigin source) {
        return this.isPluginSigningEnabled(this.loadProperties(), source);
    }

    public boolean displayOptInBanner() {
        return false;
    }

    private boolean getBooleanOr(Map<String, String> properties, String property, boolean defaultValue) {
        String value = properties.get(property);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private boolean isPluginSigningDisabled(Map<String, String> properties) {
        return this.getBooleanOr(properties, "atlassian.upm.signature.check.disabled", false);
    }

    private boolean isPluginSigningEnabled(Map<String, String> properties) {
        return !this.isPluginSigningDisabled(properties);
    }

    private boolean isPluginSigningEnabled(Map<String, String> properties, PluginInstallationOrigin source) {
        boolean globalyEnabled = this.isPluginSigningEnabled(properties);
        if (source != null && globalyEnabled) {
            String property = UpmConfig.getSourcePropertyName(source.propertyName());
            return !this.getBooleanOr(properties, property, source.disabledByDefault());
        }
        return globalyEnabled;
    }

    static Map<String, String> systemPropertiesConfiguration() {
        return UpmConfig.readConfiguration(System.getProperties());
    }

    static Map<String, String> readConfiguration(Properties properties) {
        return Collections.unmodifiableMap(properties.entrySet().stream().filter(e -> e.getKey().toString().startsWith("atlassian.upm.signature.check.")).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
    }

    private static String getSourcePropertyName(String name) {
        return "atlassian.upm.signature.check." + name + ".disabled";
    }

    public String getSafetyCheckInterval() {
        return this.checkInterval;
    }

    private List<Certificate> loadCertificates() {
        if (this.truststorePath == null) {
            LOGGER.error("Certificates Directory is null");
            return List.of();
        }
        if (!this.trustStoreStatus().success()) {
            LOGGER.debug("Certificates Directory HealthCheck failed, certificates might have been compromised");
        }
        return this.getCertificatesPaths().stream().map(this::readFile).filter(Objects::nonNull).toList();
    }

    private Certificate readFile(Path path) {
        try {
            return new Certificate(path.getFileName().toString(), Files.readString(path));
        }
        catch (IOException ioe) {
            LOGGER.warn("Error reading certificate from {}", (Object)path.getFileName());
            return null;
        }
    }

    public List<Certificate> getCertificates() {
        return this.loadCertificates();
    }
}

