/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.api.config;

import com.atlassian.sal.api.message.Message;
import com.atlassian.upm.api.log.I18nMessageParams;
import com.atlassian.upm.signing.api.config.UpmConfigStatus;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public sealed class UpmConfigPathChecker {
    private static final String USERNAME = UpmConfigPathChecker.getUsername();

    boolean strict() {
        return true;
    }

    public UpmConfigStatus checkFile(Path p) {
        UpmConfigStatus.Builder statusBuilder = UpmConfigStatus.builder().withDescription("UpmConfig Directory successfully tested").withStatus(UpmConfigStatus.Status.SUCCESS).withI18nKey("upm.config.check.success");
        List<PathPredicate> failedPredicates = Arrays.stream(PathPredicate.values()).filter(pred -> !pred.test(p)).toList();
        ArrayList fatalFailures = new ArrayList();
        failedPredicates.forEach(fp -> {
            if (fp.isError(this.strict())) {
                statusBuilder.withError(fp.messageBuilder.apply(p));
                fatalFailures.add(fp);
            } else {
                statusBuilder.withWarning(fp.messageBuilder.apply(p));
            }
        });
        if (!failedPredicates.isEmpty()) {
            if (fatalFailures.isEmpty()) {
                String cause = failedPredicates.stream().map(fp -> fp.getCause(p)).collect(Collectors.joining(", "));
                statusBuilder.withDescription("UpmConfig Directory failed strict safety check! " + cause).withStatus(UpmConfigStatus.Status.WARNING).withI18nKey("upm.config.check.warning");
            } else {
                String cause = fatalFailures.stream().map(fp -> fp.getCause(p)).collect(Collectors.joining(", "));
                statusBuilder.withDescription("UpmConfig Directory failed safety check! " + cause).withStatus(UpmConfigStatus.Status.FAILURE).withI18nKey("upm.config.check.failure");
            }
        }
        return statusBuilder.build();
    }

    public static String getUsername() {
        return ProcessHandle.current().info().user().orElse(null);
    }

    private static enum PathPredicate implements Predicate<Path>
    {
        IS_READABLE(Files::isReadable, true, "is not readable", "upm.config.check.file.not_readable"),
        IS_NOT_WRITABLE(Predicate.not(Files::isWritable), false, "is not readonly", "upm.config.check.file.not_readonly"),
        IS_NOT_SELF_OWNED((Predicate<Path>)new IsNotSelfOwnedPredicate(USERNAME), false, "belongs to the current user [" + USERNAME + "]", p -> I18nMessageParams.build("upm.config.check.file.is_self_owned", new Serializable[]{p.toString(), USERNAME}));

        private final Predicate<Path> predicate;
        private final String msgTemplate;
        private final Function<Path, Message> messageBuilder;
        private final boolean appliedOnLooseCheck;

        private PathPredicate(Predicate<Path> predicate, boolean appliedOnLooseCheck, String msgTemplate, Function<Path, Message> messageBuilder) {
            this.predicate = predicate;
            this.msgTemplate = msgTemplate;
            this.appliedOnLooseCheck = appliedOnLooseCheck;
            this.messageBuilder = messageBuilder;
        }

        private PathPredicate(Predicate<Path> predicate, boolean appliedOnLooseCheck, String msgTemplate, String i18nKey) {
            this(predicate, appliedOnLooseCheck, msgTemplate, (Path p) -> I18nMessageParams.build(i18nKey, new Serializable[]{p.toString()}));
        }

        @Override
        public boolean test(Path path) {
            return this.predicate.test(path);
        }

        public boolean isError(boolean strict) {
            return strict || this.appliedOnLooseCheck;
        }

        public String getCause(Path path) {
            return String.valueOf(path) + " " + this.msgTemplate;
        }

        private record IsNotSelfOwnedPredicate(String username) implements Predicate<Path>
        {
            @Override
            public boolean test(Path path) {
                try {
                    return !Objects.equals(this.username, Files.getOwner(path, new LinkOption[0]).getName());
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
    }

    public static final class LooseUpmConfigPathChecker
    extends UpmConfigPathChecker {
        @Override
        public boolean strict() {
            return false;
        }
    }
}

