/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.api.config;

import java.util.stream.Stream;

public final class UpmConfigSys {
    public static final String CONFIGURATION_DIRECTORY_PROPERTY = "atlassian.upm.configuration.directory";
    public static final String TRUSTSTORE_PROPERTY = "atlassian.upm.truststore.directory";
    public static final String CONFIGURATION_FILE_PROPERTY = "atlassian.upm.configuration.file";
    static final String PLUGIN_SIGNING_FEATURE_PREFIX = "atlassian.upm.signature.check.";
    public static final String PLUGIN_SIGNING_FEATURE_DISABLED = "atlassian.upm.signature.check.disabled";
    public static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    public static final String JIRA_DEV_MODE = "jira.dev.mode";
    public static final String UPM_DEBUG_MODE = "atlassian.upm.debug";
    public static final String LOOSECHECK_MODE_ALLOWED = "atlassian.upm.config.loosecheck.allowed";
    public static final String DEFAULT_CONFIG_DIRECTORY = "upmconfig";
    public static final String DEFAULT_CONFIG_FILE = "upm.properties";
    public static final String DEFAULT_TRUSTSTORE = "truststore";
    static final String CONFIG_FILE_IN_DEFAULT_CONFIG_DIRECTORY = "upmconfig/upm.properties";
    static final String TRUSTSTORE_IN_DEFAULT_CONFIG_DIRECTORY = "upmconfig/truststore";

    private UpmConfigSys() {
    }

    public static String getConfigurationDirectoryProperty() {
        return System.getProperty(CONFIGURATION_DIRECTORY_PROPERTY);
    }

    public static String getConfigurationFileProperty() {
        return System.getProperty(CONFIGURATION_FILE_PROPERTY);
    }

    public static String getTrustStoreProperty() {
        return System.getProperty(TRUSTSTORE_PROPERTY);
    }

    public static String getDefaultConfigurationFile() {
        return CONFIG_FILE_IN_DEFAULT_CONFIG_DIRECTORY;
    }

    public static String getDefaultTrustStore() {
        return TRUSTSTORE_IN_DEFAULT_CONFIG_DIRECTORY;
    }

    static boolean isLooseCheckingAllowed() {
        return Stream.of(LOOSECHECK_MODE_ALLOWED, ATLASSIAN_DEV_MODE, JIRA_DEV_MODE, UPM_DEBUG_MODE).map(Boolean::getBoolean).filter(Boolean::booleanValue).findAny().orElse(false);
    }
}

