/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.UpmSys;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@SystemAdminOnly
@Path(value="/test/bundle-id")
public class BundleIdResource {
    private final PermissionEnforcer permissionEnforcer;
    private final UpmInformation upm;

    @Inject
    public BundleIdResource(PermissionEnforcer permissionEnforcer, UpmInformation upm) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.upm = Objects.requireNonNull(upm, "upm");
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getBundleId() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!UpmSys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        return Response.ok((Object)String.valueOf(this.upm.getBundleId())).build();
    }
}

