/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.upm.UpmSys;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.PacClient;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Path(value="/test/marketplace-cache")
public class MarketplaceCacheResource {
    private final PermissionEnforcer permissionEnforcer;
    private final PacClient pacClient;

    @Inject
    public MarketplaceCacheResource(PermissionEnforcer permissionEnforcer, PacClient pacClient) {
        this.permissionEnforcer = permissionEnforcer;
        this.pacClient = pacClient;
    }

    @DELETE
    public Response clearCache() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!UpmSys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        this.pacClient.clearAllCachedMarketplaceState();
        return Response.ok().build();
    }
}

