/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.upm.UpmSys;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.schedule.UpmScheduler;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Path(value="/test/scheduler")
public class RunScheduledJobResource {
    private final UpmScheduler upmScheduler;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public RunScheduledJobResource(PermissionEnforcer permissionEnforcer, UpmScheduler upmScheduler) {
        this.permissionEnforcer = permissionEnforcer;
        this.upmScheduler = upmScheduler;
    }

    @GET
    public Response waitForCompletion() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!UpmSys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        this.upmScheduler.waitForTriggeredJobs();
        return Response.ok().build();
    }

    @Path(value="/{jobClass}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @XsrfProtectionExcluded
    public Response triggerJob(@PathParam(value="jobClass") String jobClassName, @QueryParam(value="runMode") UpmScheduler.RunMode runMode) throws Exception {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!UpmSys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        Class<?> jobClass = Class.forName(jobClassName);
        this.upmScheduler.triggerJob(jobClass, runMode == null ? UpmScheduler.RunMode.TRIGGERED_INTERNALLY : runMode);
        return Response.ok().build();
    }
}

