/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.transformers.template;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.upm.transformers.template.UnderscoreTemplateRenderer;
import com.atlassian.upm.transformers.webresource.UrlReadingWebResourceUrlBuilder;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.transformer.TransformableResource;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.transformer.TransformerUrlBuilder;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.webresource.spi.transformer.WebResourceTransformerFactory;
import java.util.Objects;

public class UrlReadingUnderscoreTemplateWebResourceTransformer
implements WebResourceTransformerFactory {
    private final UnderscoreTemplateRenderer underscoreTemplateRenderer;
    private final UrlReadingWebResourceUrlBuilder urlReadingWebResourceUrlBuilder;

    public UrlReadingUnderscoreTemplateWebResourceTransformer(UnderscoreTemplateRenderer underscoreTemplateRenderer, UrlReadingWebResourceUrlBuilder urlReadingWebResourceUrlBuilder) {
        this.underscoreTemplateRenderer = Objects.requireNonNull(underscoreTemplateRenderer);
        this.urlReadingWebResourceUrlBuilder = Objects.requireNonNull(urlReadingWebResourceUrlBuilder);
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return new UnderscoreTemplateUrlBuilder();
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return new UnderscoreTemplateResourceTransformer();
    }

    private final class UnderscoreTemplateUrlBuilder
    implements TransformerUrlBuilder {
        private UnderscoreTemplateUrlBuilder() {
        }

        public void addToUrl(UrlBuilder urlBuilder) {
            UrlReadingUnderscoreTemplateWebResourceTransformer.this.urlReadingWebResourceUrlBuilder.build(urlBuilder);
        }
    }

    private final class UnderscoreTemplateResourceTransformer
    implements UrlReadingWebResourceTransformer {
        private UnderscoreTemplateResourceTransformer() {
        }

        public DownloadableResource transform(final TransformableResource transformableResource, QueryParams params) {
            return new CharSequenceDownloadableResource(transformableResource.nextResource()){

                protected CharSequence transform(CharSequence templateContent) {
                    return UrlReadingUnderscoreTemplateWebResourceTransformer.this.underscoreTemplateRenderer.renderUnderscoreTemplate(transformableResource.location().getLocation(), templateContent);
                }
            };
        }
    }
}

