/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.comment.like.UserReaction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.emoticons.Emoticon;
import com.atlassian.bitbucket.emoticons.EmoticonService;
import com.atlassian.bitbucket.emoticons.SimpleEmoticon;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.comment.like.CommentReactionLimitExceededException;
import com.atlassian.stash.internal.comment.like.InternalCommentReactionService;
import com.atlassian.stash.internal.comment.like.InternalUserReaction;
import com.atlassian.stash.internal.comment.like.Reaction;
import com.atlassian.stash.internal.comment.like.SimpleUserReaction;
import com.atlassian.stash.internal.comment.like.config.CommentReactionConfig;
import com.atlassian.stash.internal.comment.like.dao.CommentReactionDao;
import com.atlassian.stash.internal.comment.like.notification.CommentReactionPullRequestNotificationEvent;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommentReactionService
implements InternalCommentReactionService {
    private static final int MAX_EMOTICON_LENGTH = 20;
    private static final Logger log = LoggerFactory.getLogger(DefaultCommentReactionService.class);
    private final AuthenticationContext authenticationContext;
    private final CommentReactionConfig commentReactionConfig;
    private final CommentReactionDao commentReactionDao;
    private final EmoticonService emoticonService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    public DefaultCommentReactionService(AuthenticationContext authenticationContext, CommentReactionDao commentReactionDao, CommentReactionConfig commentReactionConfig, EmoticonService emoticonService, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, TransactionTemplate transactionTemplate, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.commentReactionDao = commentReactionDao;
        this.commentReactionConfig = commentReactionConfig;
        this.emoticonService = emoticonService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
    }

    @Override
    @Nonnull
    public UserReaction addReaction(@Nonnull Repository repository, final @Nonnull Comment comment, @Nonnull String emoticonShortcut) {
        this.permissionValidationService.validateForRepository(Objects.requireNonNull(repository, "repository"), Permission.REPO_READ);
        Objects.requireNonNull(comment, "comment");
        this.checkCommentIsAccessible(comment);
        int totalReactionCount = this.commentReactionDao.getTotalReactionCount(comment.getId());
        if (totalReactionCount >= this.commentReactionConfig.getMaxResources()) {
            throw new CommentReactionLimitExceededException(this.i18nService.createKeyedMessage("bitbucket.reaction.comment.maximum.total.reaction.limit.reached", new Object[]{totalReactionCount}));
        }
        final Emoticon emoticon = this.getEmoticon(emoticonShortcut = Objects.requireNonNull(StringUtils.stripToNull((String)emoticonShortcut), "emoticonShortcut"));
        if (emoticon == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.reaction.comment.reaction.unknown", new Object[]{emoticonShortcut}));
        }
        final ApplicationUser currentUser = Objects.requireNonNull(this.authenticationContext.getCurrentUser());
        this.transactionTemplate.execute(() -> this.commentReactionDao.get(comment.getId(), currentUser.getId(), emoticon.getShortcut()).orElseGet(() -> {
            InternalUserReaction created = this.commentReactionDao.create(comment.getId(), currentUser.getId(), emoticon.getShortcut(), new Date());
            comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<Void>(){

                public Void visit(@Nonnull CommitDiscussion discussion) {
                    log.debug("Unsupported operation: Unable to add reaction to commit discussions");
                    return null;
                }

                public Void visit(@Nonnull PullRequest pullRequest) {
                    HashSet recipients = Sets.newHashSetWithExpectedSize((int)2);
                    recipients.add(comment.getAuthor());
                    recipients.add(pullRequest.getAuthor().getUser());
                    recipients.remove(currentUser);
                    DefaultCommentReactionService.this.eventPublisher.publish((Object)new CommentReactionPullRequestNotificationEvent(this, recipients, pullRequest, comment, currentUser, new Date(), emoticon));
                    return null;
                }
            });
            return created;
        }));
        return new SimpleUserReaction(comment, emoticon, currentUser);
    }

    @Override
    @Nonnull
    public Map<Long, List<Reaction>> findReactions(@Nonnull Iterable<Comment> comments) {
        Objects.requireNonNull(comments, "comments");
        Set<Long> commentIds = this.getUniqueCommentIds(comments);
        return (Map)this.transactionTemplate.execute(() -> this.commentReactionDao.findByCommentIds(commentIds).stream().collect(Collectors.groupingBy(InternalUserReaction::getCommentId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getReactionsForComment((List)entry.getValue()))));
    }

    @Override
    @Nonnull
    public Optional<UserReaction> getReaction(@Nonnull Repository repository, @Nonnull Comment comment, @Nonnull String emoticonShortcut) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(comment, "comment");
        this.checkCommentIsAccessible(comment);
        emoticonShortcut = Objects.requireNonNull(StringUtils.stripToNull((String)emoticonShortcut), "emoticonShortcut");
        if (emoticonShortcut.length() > 20) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.reaction.comment.reaction.emoticon.long", new Object[]{20}));
        }
        Emoticon emoticon = this.getEmoticon(emoticonShortcut);
        if (emoticon == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.reaction.comment.reaction.unknown", new Object[]{emoticonShortcut}));
        }
        return (Optional)this.transactionTemplate.execute(() -> {
            this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            return this.commentReactionDao.get(comment.getId(), currentUser.getId(), emoticon.getShortcut()).map(internalUserReaction -> new SimpleUserReaction(comment, emoticon, currentUser));
        });
    }

    @Override
    public boolean hasReacted(@Nonnull Repository repository, @Nonnull Comment comment) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(comment, "comment");
        return (Boolean)this.transactionTemplate.execute(() -> {
            this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
            return this.commentReactionDao.getReactionCount(comment.getId(), this.authenticationContext.getCurrentUser().getId()) > 0;
        });
    }

    @EventListener
    public void onCommitCommentDeleted(CommitDiscussionCommentDeletedEvent commentDeleted) {
        this.cleanUpReactions(commentDeleted.getComment());
    }

    @EventListener
    public void onPullRequestCommentDeleted(PullRequestCommentDeletedEvent commentDeleted) {
        this.cleanUpReactions(commentDeleted.getComment());
    }

    @Override
    public void removeReaction(@Nonnull Repository repository, @Nonnull Comment comment, @Nonnull String emoticon) {
        this.permissionValidationService.validateForRepository(Objects.requireNonNull(repository, "repository"), Permission.REPO_READ);
        this.checkCommentIsAccessible(comment);
        Objects.requireNonNull(comment, "comment");
        Objects.requireNonNull(StringUtils.stripToNull((String)emoticon), "reaction");
        this.transactionTemplate.execute(() -> {
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            this.commentReactionDao.delete(comment.getId(), currentUser.getId(), emoticon);
            return null;
        });
    }

    @Override
    @Nonnull
    public Map<Long, Collection<Integer>> retainExisting(@Nonnull Map<Long, Collection<Integer>> commentReactions) {
        Objects.requireNonNull(commentReactions, "commentReactions");
        return (Map)this.transactionTemplate.execute(() -> this.commentReactionDao.retainExisting(commentReactions));
    }

    private void checkCommentIsAccessible(Comment comment) {
        if (comment.getState() == CommentState.PENDING && !comment.getAuthor().equals((Object)this.authenticationContext.getCurrentUser())) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.reaction.comment.reaction.pending.other.user", new Object[0]));
        }
    }

    private void cleanUpReactions(Comment comment) {
        this.transactionTemplate.execute(() -> {
            this.commentReactionDao.deleteByCommentId(comment.getId());
            return null;
        });
    }

    private Emoticon getEmoticon(String shortcut) {
        return this.emoticonService.get(shortcut);
    }

    private Set<ApplicationUser> getReactingUsers(List<InternalUserReaction> userReactions) {
        Set userIds = userReactions.stream().map(InternalUserReaction::getUserId).collect(Collectors.toSet());
        return this.userService.getUsersById(userIds, true);
    }

    private List<Reaction> getReactionsForComment(List<InternalUserReaction> reactionsForComment) {
        return reactionsForComment.stream().collect(Collectors.groupingBy(userReaction -> (String)StringUtils.firstNonBlank((CharSequence[])new String[]{userReaction.getEmoticon(), this.commentReactionConfig.getDefaultReaction()}), LinkedHashMap::new, Collectors.toList())).entrySet().stream().map(entry -> {
            String shortcut = (String)entry.getKey();
            Emoticon emoticon = this.getEmoticon(shortcut);
            if (emoticon == null) {
                emoticon = new SimpleEmoticon.Builder(shortcut).build();
            }
            return new Reaction(emoticon, this.getReactingUsers((List)entry.getValue()));
        }).collect(Collectors.toList());
    }

    private Set<Long> getUniqueCommentIds(Iterable<Comment> comments) {
        Set<Long> commentIds = MoreStreams.streamIterable(comments).map(Comment::getId).collect(Collectors.toSet());
        if (commentIds.size() > this.commentReactionConfig.getMaxResources()) {
            log.warn("Max resources limit: {} reached for comment IDs, results may be inaccurate", (Object)this.commentReactionConfig.getMaxResources());
            commentIds = commentIds.stream().limit(this.commentReactionConfig.getMaxResources()).collect(Collectors.toSet());
        }
        return commentIds;
    }
}

