/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.comment.like.InternalUserReaction;
import com.atlassian.stash.internal.comment.like.SimpleInternalUserReaction;
import com.atlassian.stash.internal.comment.like.config.CommentReactionConfig;
import com.atlassian.stash.internal.comment.like.dao.AoCommentLike;
import com.atlassian.stash.internal.comment.like.dao.CommentReactionDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoCommentReactionDao
extends AbstractAoDao
implements CommentReactionDao {
    private static final Logger log = LoggerFactory.getLogger(AoCommentReactionDao.class);
    private static final String COMMENT_QUERY = "COMMENT_ID = ?";
    private static final String COMMENT_AND_EMOTICON_QUERY = "COMMENT_ID = ? AND EMOTICON = ?";
    private static final String COMMENT_AND_USER_QUERY = "COMMENT_ID = ? AND USER_ID = ?";
    private static final String COMMENT_AND_USER_AND_NULL_QUERY = "COMMENT_ID = ? AND USER_ID = ? AND EMOTICON is null";
    private static final String COMMENT_USER_AND_EMOTICON_QUERY = "COMMENT_ID = ? AND USER_ID = ? AND EMOTICON = ?";
    private static final int IN_LIMIT = 100;
    private final CommentReactionConfig commentReactionConfig;
    private final int inClauseLimit;

    public AoCommentReactionDao(ActiveObjects ao, CommentReactionConfig commentReactionConfig) {
        this(ao, commentReactionConfig, 100);
    }

    @VisibleForTesting
    AoCommentReactionDao(ActiveObjects ao, CommentReactionConfig commentReactionConfig, int inClauseLimit) {
        super(ao);
        this.commentReactionConfig = commentReactionConfig;
        this.inClauseLimit = inClauseLimit;
    }

    @Override
    @Nonnull
    public InternalUserReaction create(long commentId, int userId, @Nonnull String emoticon, @Nonnull Date createdAt) {
        ImmutableMap.Builder params = ImmutableMap.builder().put((Object)"COMMENT_ID", (Object)commentId).put((Object)"USER_ID", (Object)userId).put((Object)"CREATED_AT", (Object)createdAt).put((Object)"EMOTICON", (Object)emoticon);
        AoCommentLike created = (AoCommentLike)this.ao.create(AoCommentLike.class, (Map)params.build());
        return this.toReaction(created);
    }

    @Override
    public boolean delete(long commentId, int userId, @Nonnull String emoticon) {
        int count = this.ao.deleteWithSQL(AoCommentLike.class, COMMENT_USER_AND_EMOTICON_QUERY, new Object[]{commentId, userId, emoticon});
        if (this.commentReactionConfig.getDefaultReaction().equals(emoticon)) {
            count += this.ao.deleteWithSQL(AoCommentLike.class, COMMENT_AND_USER_AND_NULL_QUERY, new Object[]{commentId, userId});
        }
        return count > 0;
    }

    @Override
    public int deleteByCommentId(long commentId) {
        return this.ao.deleteWithSQL(AoCommentLike.class, COMMENT_QUERY, new Object[]{commentId});
    }

    @Override
    @Nonnull
    public Optional<InternalUserReaction> get(long commentId, int userId, @Nonnull String emoticon) {
        Optional<AoCommentLike> existing = Arrays.stream((AoCommentLike[])this.ao.find(AoCommentLike.class, COMMENT_USER_AND_EMOTICON_QUERY, new Object[]{commentId, userId, emoticon})).findFirst();
        if (!existing.isPresent() && this.commentReactionConfig.getDefaultReaction().equals(emoticon)) {
            existing = Arrays.stream((AoCommentLike[])this.ao.find(AoCommentLike.class, COMMENT_AND_USER_AND_NULL_QUERY, new Object[]{commentId, userId})).findFirst();
        }
        return existing.map(this::toReaction);
    }

    @Override
    public int getTotalReactionCount(long commentId) {
        return this.ao.count(AoCommentLike.class, COMMENT_QUERY, new Object[]{commentId});
    }

    @Override
    public int getReactionCount(long commentId, int userId) {
        return this.ao.count(AoCommentLike.class, COMMENT_AND_USER_QUERY, new Object[]{commentId, userId});
    }

    @Override
    @Nonnull
    public Iterable<Integer> findByCommentId(long commentId) {
        ImmutableList reactions = ImmutableList.copyOf((Object[])((AoCommentLike[])this.ao.find(AoCommentLike.class, Query.select().where(COMMENT_QUERY, new Object[]{commentId}).limit(this.commentReactionConfig.getMaxResources()))));
        if (reactions.size() >= this.commentReactionConfig.getMaxResources()) {
            log.warn("Max resources limit: {} reached for comment ID {}, results may be inaccurate", (Object)this.commentReactionConfig.getMaxResources(), (Object)commentId);
        }
        return Chainable.chain((Iterable)reactions).transform(AoCommentLike::getUserId).toSet();
    }

    @Override
    @Nonnull
    public List<InternalUserReaction> findByCommentIds(@Nonnull Set<Long> commentIds) {
        ArrayList<InternalUserReaction> allReactions = new ArrayList<InternalUserReaction>();
        for (List commentIdsBatch : Iterables.partition(commentIds, (int)this.inClauseLimit)) {
            allReactions.addAll(this.findReactionsByCommentIdsInternal(commentIdsBatch).stream().map(this::toReaction).collect(Collectors.toList()));
            if (allReactions.size() < this.commentReactionConfig.getMaxResources()) continue;
            log.warn("Max resources limit: {} reached for comment IDs {}, results may be inaccurate", (Object)this.commentReactionConfig.getMaxResources(), commentIds);
            break;
        }
        return allReactions;
    }

    @Override
    @Nonnull
    public Map<Long, Collection<Integer>> retainExisting(@Nonnull Map<Long, Collection<Integer>> commentReactions) {
        ArrayList<Number> queryParameters = new ArrayList<Number>();
        block0: for (Map.Entry<Long, Collection<Integer>> entry : commentReactions.entrySet()) {
            Long commentId = entry.getKey();
            for (Integer userId : entry.getValue()) {
                queryParameters.add(commentId);
                queryParameters.add(userId);
                if (queryParameters.size() / 2 < this.commentReactionConfig.getMaxResources()) continue;
                log.warn("Max resources limit: {} reached for reaction checks {}, results may be inaccurate", (Object)this.commentReactionConfig.getMaxResources(), (Object)(queryParameters.size() / 2));
                break block0;
            }
        }
        HashMultimap results = HashMultimap.create();
        if (!queryParameters.isEmpty()) {
            AoCommentLike[] reactions;
            for (AoCommentLike reaction : reactions = (AoCommentLike[])this.ao.find(AoCommentLike.class, this.createRetainExistingQuery(queryParameters))) {
                results.put((Object)reaction.getCommentId(), (Object)reaction.getUserId());
            }
        }
        return results.asMap();
    }

    private List<AoCommentLike> findReactionsByCommentIdsInternal(Iterable<Long> commentIds) {
        return ImmutableList.copyOf((Object[])((AoCommentLike[])this.ao.find(AoCommentLike.class, this.createFindReactionsByCommentIdsQuery("COMMENT_ID", commentIds))));
    }

    private Query createFindReactionsByCommentIdsQuery(String columnName, Iterable<Long> commentIds) {
        Object[] inParams = new Object[Iterables.size(commentIds)];
        Arrays.fill(inParams, "?");
        return Query.select().where(columnName + " IN (" + Joiner.on((String)",").join(inParams) + ")", Iterables.toArray(commentIds, Object.class)).order("CREATED_AT ASC").limit(this.commentReactionConfig.getMaxResources());
    }

    private Query createRetainExistingQuery(Iterable<Number> commentAndUserIds) {
        Object[] clauses = new Object[Iterables.size(commentAndUserIds) / 2];
        Arrays.fill(clauses, "(COMMENT_ID = ? AND USER_ID = ?)");
        return Query.select().where(Joiner.on((String)" OR ").join(clauses), Iterables.toArray(commentAndUserIds, Object.class)).limit(this.commentReactionConfig.getMaxResources());
    }

    private SimpleInternalUserReaction toReaction(AoCommentLike aoCommentLike) {
        return new SimpleInternalUserReaction(aoCommentLike.getCommentId(), aoCommentLike.getUserId(), (String)ObjectUtils.firstNonNull((Object[])new String[]{aoCommentLike.getEmoticon(), this.commentReactionConfig.getDefaultReaction()}));
    }
}

