/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.notification;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

class CommentReactionData {
    private final Comment comment;
    private final String emoticonShortcut;
    private final Set<ApplicationUser> reacters;
    private Date date;

    public CommentReactionData(@Nonnull Comment comment, @Nonnull String emoticonShortcut) {
        this.comment = Objects.requireNonNull(comment, "comment");
        this.emoticonShortcut = Objects.requireNonNull(emoticonShortcut, "emoticonShortcut");
        this.date = new Date();
        this.reacters = new LinkedHashSet<ApplicationUser>();
    }

    public void addReacter(@Nonnull ApplicationUser reacter, @Nonnull Date date) {
        this.reacters.add(reacter);
        if (this.date.after(date)) {
            this.date = date;
        }
    }

    @Nonnull
    public Comment getComment() {
        return this.comment;
    }

    @Nonnull
    public Date getDate() {
        return this.date;
    }

    @Nonnull
    public String getEmoticonShortcut() {
        return this.emoticonShortcut;
    }

    @Nonnull
    public Collection<ApplicationUser> getReacters() {
        return this.reacters;
    }
}

