/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.notification;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.comment.like.InternalCommentReactionService;
import com.atlassian.stash.internal.comment.like.notification.CommentReactionData;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Map;

class CommentReactionFilter {
    private final InternalCommentReactionService commentReactionService;

    public CommentReactionFilter(@Nonnull InternalCommentReactionService commentReactionService) {
        this.commentReactionService = commentReactionService;
    }

    public Multimap<ApplicationUser, CommentReactionData> filterRemovedReactions(Multimap<ApplicationUser, CommentReactionData> reactionData) {
        Map<Long, Collection<Integer>> associations = this.asCommentAssociations(reactionData);
        Map<Long, Collection<Integer>> validAssociations = this.commentReactionService.retainExisting(associations);
        return !validAssociations.equals(associations) ? this.filterNonExistent(reactionData, validAssociations) : reactionData;
    }

    private Map<Long, Collection<Integer>> asCommentAssociations(Multimap<ApplicationUser, CommentReactionData> userToReactionData) {
        HashMultimap commentsToUsers = HashMultimap.create();
        for (Map.Entry entry : userToReactionData.entries()) {
            CommentReactionData data = (CommentReactionData)entry.getValue();
            for (ApplicationUser reacter : data.getReacters()) {
                commentsToUsers.put((Object)data.getComment().getId(), (Object)reacter.getId());
            }
        }
        return commentsToUsers.asMap();
    }

    private Multimap<ApplicationUser, CommentReactionData> filterNonExistent(Multimap<ApplicationUser, CommentReactionData> allReactionData, Map<Long, Collection<Integer>> existingReactions) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Map.Entry entry : allReactionData.entries()) {
            ApplicationUser recipient = (ApplicationUser)entry.getKey();
            CommentReactionData reactionData = (CommentReactionData)entry.getValue();
            CommentReactionData filteredReactionData = this.filterReactionData(existingReactions, reactionData);
            if (filteredReactionData == null) continue;
            result.put((Object)recipient, (Object)filteredReactionData);
        }
        return result;
    }

    @Nullable
    private CommentReactionData filterReactionData(Map<Long, Collection<Integer>> existingReactions, CommentReactionData reactionData) {
        Collection<Integer> existingReactionsForComment = existingReactions.get(reactionData.getComment().getId());
        if (existingReactionsForComment == null || existingReactionsForComment.isEmpty()) {
            return null;
        }
        CommentReactionData filtered = new CommentReactionData(reactionData.getComment(), reactionData.getEmoticonShortcut());
        for (ApplicationUser originalReacter : reactionData.getReacters()) {
            if (!existingReactionsForComment.contains(originalReacter.getId())) continue;
            filtered.addReacter(originalReacter, reactionData.getDate());
        }
        if (filtered.getReacters().isEmpty()) {
            return null;
        }
        return filtered;
    }
}

