/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.notification;

import com.atlassian.bitbucket.mail.HtmlCssInliner;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.comment.like.notification.CommentReactionData;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;

class CommentReactionNotificationRenderer {
    static final String EMAIL_CSS_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-comment-likes:comment-likes-email-styles";
    static final String EMAIL_TEMPLATE_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-comment-likes:comment-likes-email-templates";
    static final String TEMPLATE = "email.emailCommentLikes.like";
    private final HtmlCssInliner htmlCssInliner;
    private final SecurityService securityService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public CommentReactionNotificationRenderer(@Nonnull HtmlCssInliner htmlCssInliner, @Nonnull SecurityService securityService, @Nonnull SoyTemplateRenderer soyTemplateRenderer) {
        this.htmlCssInliner = htmlCssInliner;
        this.securityService = securityService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @Nonnull
    public String render(final @Nonnull ApplicationUser recipient, final @Nonnull CommentReactionData reactionData) {
        return (String)this.securityService.impersonating(recipient, "Rendering reaction in user's locale").call((Operation)new UncheckedOperation<String>(){

            public String perform() {
                return CommentReactionNotificationRenderer.this.htmlCssInliner.inlineCss(CommentReactionNotificationRenderer.this.soyTemplateRenderer.render(CommentReactionNotificationRenderer.EMAIL_TEMPLATE_MODULE_KEY, CommentReactionNotificationRenderer.TEMPLATE, (Map)ImmutableMap.of((Object)"comment", (Object)reactionData.getComment(), (Object)"emoticonShortcut", (Object)reactionData.getEmoticonShortcut(), (Object)"reacters", reactionData.getReacters(), (Object)"recipient", (Object)recipient)), CommentReactionNotificationRenderer.EMAIL_CSS_MODULE_KEY);
            }
        });
    }
}

