/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.notification;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationData;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomPullRequestNotificationEvent;
import com.atlassian.bitbucket.emoticons.Emoticon;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Map;

@AsynchronousPreferred
@TransactionAware
public class CommentReactionPullRequestNotificationEvent
extends CustomPullRequestNotificationEvent {
    static final String COMMENT_KEY = "comment";
    static final String DATE_KEY = "date";
    static final String EMOTICON_SHORTCUT_KEY = "emoticonShortcut";
    static final String REACTER_KEY = "reacter";

    public CommentReactionPullRequestNotificationEvent(@Nonnull Object source, @Nonnull Iterable<ApplicationUser> recipients, @Nonnull PullRequest pullRequest, @Nonnull Comment comment, @Nonnull ApplicationUser reacter, @Nonnull Date date, @Nonnull Emoticon emoticon) {
        super(source, "com.atlassian.bitbucket.server.bitbucket-comment-likes", pullRequest, recipients, CommentReactionPullRequestNotificationEvent.asNotificationData(comment, reacter, date, emoticon));
    }

    private static CustomNotificationData asNotificationData(Comment comment, ApplicationUser reacter, Date date, Emoticon emoticon) {
        return new CustomNotificationData((Map)ImmutableMap.of((Object)COMMENT_KEY, (Object)comment.getId(), (Object)DATE_KEY, (Object)date.getTime(), (Object)EMOTICON_SHORTCUT_KEY, (Object)emoticon.getShortcut(), (Object)REACTER_KEY, (Object)reacter.getId()));
    }
}

