/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.notification;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentService;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationData;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationSection;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomPullRequestNotificationRenderer;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.comment.like.notification.CommentReactionData;
import com.atlassian.stash.internal.comment.like.notification.CommentReactionFilter;
import com.atlassian.stash.internal.comment.like.notification.CommentReactionNotificationRenderer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CommentReactionPullRequestNotificationRenderer
implements CustomPullRequestNotificationRenderer {
    static final String ID = "com.atlassian.bitbucket.server.bitbucket-comment-likes";
    private final CommentReactionNotificationRenderer renderer;
    private final CommentReactionFilter commentReactionFilter;
    private final CommentService commentService;
    private final UserService userService;
    private final SecurityService securityService;

    public CommentReactionPullRequestNotificationRenderer(@Nonnull CommentReactionNotificationRenderer renderer, @Nonnull CommentReactionFilter commentReactionFilter, @Nonnull CommentService commentService, @Nonnull SecurityService securityService, @Nonnull UserService userService) {
        this.commentReactionFilter = commentReactionFilter;
        this.commentService = commentService;
        this.renderer = renderer;
        this.securityService = securityService;
        this.userService = userService;
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    @Nonnull
    public Map<ApplicationUser, Collection<CustomNotificationSection>> render(@Nonnull PullRequest pullRequest, @Nonnull Map<ApplicationUser, Collection<CustomNotificationData>> userData) {
        Multimap<ApplicationUser, CommentReactionData> userToLikeData = this.deserialize(userData);
        userToLikeData = this.commentReactionFilter.filterRemovedReactions(userToLikeData);
        ArrayListMultimap result = ArrayListMultimap.create();
        userToLikeData.entries().forEach(arg_0 -> this.lambda$render$0((Multimap)result, arg_0));
        return Collections.unmodifiableMap(result.asMap());
    }

    private Multimap<ApplicationUser, CommentReactionData> deserialize(Map<ApplicationUser, Collection<CustomNotificationData>> userData) {
        ArrayListMultimap result = ArrayListMultimap.create();
        userData.entrySet().forEach(arg_0 -> this.lambda$deserialize$1((Multimap)result, arg_0));
        return result;
    }

    private Collection<CommentReactionData> deserialize(Collection<CustomNotificationData> dataCollection) {
        return (Collection)this.securityService.withPermission(Permission.REPO_READ, "Reading comments to render like notifications").call(() -> {
            HashMap reactData = new HashMap();
            Map<Long, Comment> commentData = this.toCommentsByIds(dataCollection);
            dataCollection.forEach(data -> {
                Comment comment = (Comment)commentData.get(((Number)data.getData().get("comment")).longValue());
                if (comment != null) {
                    String emoticonShortcut = (String)data.getData().get("emoticonShortcut");
                    ApplicationUser reacter = this.getUser((Number)data.getData().get("reacter"));
                    if (reacter != null) {
                        ImmutablePair key = new ImmutablePair((Object)comment.getId(), (Object)emoticonShortcut);
                        reactData.computeIfAbsent(key, id -> new CommentReactionData(comment, emoticonShortcut)).addReacter(reacter, new Date(((Number)data.getData().get("date")).longValue()));
                    }
                }
            });
            return reactData.values();
        });
    }

    private ApplicationUser getUser(Number reacterId) {
        return this.userService.getUserById(reacterId.intValue(), true);
    }

    private Map<Long, Comment> toCommentsByIds(Collection<CustomNotificationData> datas) {
        return (Map)datas.stream().map(data -> ((Number)data.getData().get("comment")).longValue()).distinct().map(arg_0 -> ((CommentService)this.commentService).getComment(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(MoreCollectors.toImmutableMap(Comment::getId, Function.identity()));
    }

    private /* synthetic */ void lambda$deserialize$1(Multimap result, Map.Entry userToLike) {
        result.putAll((Object)((ApplicationUser)userToLike.getKey()), this.deserialize((Collection)userToLike.getValue()));
    }

    private /* synthetic */ void lambda$render$0(Multimap result, Map.Entry userToLike) {
        String content = this.renderer.render((ApplicationUser)userToLike.getKey(), (CommentReactionData)userToLike.getValue());
        result.put((Object)((ApplicationUser)userToLike.getKey()), (Object)new CustomNotificationSection(content, ((CommentReactionData)userToLike.getValue()).getDate()));
    }
}

