/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.notification;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.comment.like.InternalCommentReactionService;
import java.util.Map;

public class UserHasReactedToCommentCondition
implements Condition {
    protected static final String COMMENT = "comment";
    protected static final String PULL_REQUEST = "pullRequest";
    protected final AuthenticationContext authenticationContext;
    protected final InternalCommentReactionService commentReactionService;

    public UserHasReactedToCommentCondition(AuthenticationContext authenticationContext, InternalCommentReactionService commentReactionService) {
        this.authenticationContext = authenticationContext;
        this.commentReactionService = commentReactionService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        PullRequest pullRequest = (PullRequest)context.get(PULL_REQUEST);
        if (pullRequest == null) {
            throw new IllegalStateException("Condition context does not have a pullRequest object on it");
        }
        Comment comment = (Comment)context.get(COMMENT);
        if (comment == null) {
            throw new IllegalStateException("Condition context does not have a comment object on it");
        }
        return this.commentReactionService.hasReacted(pullRequest.getToRef().getRepository(), comment);
    }
}

