/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.property;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentPropertyContext;
import com.atlassian.bitbucket.comment.FlatteningCommentPropertyProvider;
import com.atlassian.stash.internal.comment.like.InternalCommentReactionService;
import com.atlassian.stash.internal.comment.like.Reaction;
import com.atlassian.stash.internal.comment.like.rest.RestReaction;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CommentReactionPropertyProvider
extends FlatteningCommentPropertyProvider {
    private static final String REACTIONS = "reactions";
    private final InternalCommentReactionService commentReactionService;

    public CommentReactionPropertyProvider(InternalCommentReactionService commentReactionService) {
        this.commentReactionService = commentReactionService;
    }

    protected void doProvideProperties(@Nonnull CommentPropertyContext context) {
        Map<Long, List<Reaction>> commentReactions = this.commentReactionService.findReactions((Iterable<Comment>)context);
        for (Comment comment : context) {
            List<Reaction> reactions = commentReactions.get(comment.getId());
            if (reactions == null || reactions.isEmpty()) continue;
            context.setProperty(comment, REACTIONS, reactions.stream().map(RestReaction::new).collect(Collectors.toList()));
        }
    }
}

