/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.comment.like.CommentReactionService;
import com.atlassian.bitbucket.comment.like.UserReaction;
import com.atlassian.bitbucket.rest.v2.api.resolver.CommentResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.comment.like.rest.RestUserReaction;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@PathParamDocs(value={@PathParamDoc(name="commentId", documentation="The comment id"), @PathParamDoc(name="commitId", documentation="The commit id"), @PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Tag(name="Repository")
@LicensedOnly
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}/reactions")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class CommitCommentReactionResource {
    private final CommentReactionService commentReactionService;

    @Inject
    public CommitCommentReactionResource(CommentReactionService commentReactionService) {
        this.commentReactionService = commentReactionService;
    }

    @Operation(description="Add an emoticon reaction to a comment", summary="React to a comment")
    @Parameters(value={@Parameter(description="The emoticon to add", in=ParameterIn.PATH, name="emoticon")})
    @ResponseDocs(value={@ResponseDoc(documentation="The added reaction", responseCode=200, representation=RestUserReaction.class)})
    @PUT
    @Path(value="{emoticon}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response react(@BeanParam RepositoryResolver repositoryResolver, @BeanParam CommentResolver commentResolver, @PathParam(value="emoticon") String emoticon) {
        UserReaction reaction = this.commentReactionService.addReaction(repositoryResolver.getRepository(), commentResolver.getComment(), emoticon);
        return Response.ok((Object)((Object)new RestUserReaction(reaction))).build();
    }

    @Operation(description="Remove an emoticon reaction from a comment", summary="Remove a reaction from comment")
    @Parameters(value={@Parameter(description="The emoticon to remove", in=ParameterIn.PATH, name="emoticon")})
    @ResponseDocs(value={@ResponseDoc(documentation="The added reaction", responseCode=204)})
    @DELETE
    @Path(value="{emoticon}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response unReact(@BeanParam RepositoryResolver repositoryResolver, @BeanParam CommentResolver commentResolver, @PathParam(value="emoticon") String emoticon) {
        this.commentReactionService.removeReaction(repositoryResolver.getRepository(), commentResolver.getComment(), emoticon);
        return Response.noContent().build();
    }
}

