/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.rest;

import com.atlassian.bitbucket.emoticons.Emoticon;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import jakarta.annotation.Nullable;
import java.util.Map;

public class RestEmoticon
extends RestMapEntity {
    private static final String SHORTCUT = "shortcut";
    private static final String URL = "url";
    private static final String VALUE = "value";

    public RestEmoticon() {
    }

    public RestEmoticon(Emoticon emoticon) {
        this.put(SHORTCUT, emoticon.getShortcut());
        emoticon.getUrl().ifPresent(url -> this.put(URL, url));
        emoticon.getValue().ifPresent(value -> this.put(VALUE, value));
    }

    private RestEmoticon(Map<String, Object> map) {
        super(map);
    }

    @Nullable
    public static RestEmoticon valueOf(@Nullable Object value) {
        if (value instanceof RestEmoticon) {
            return (RestEmoticon)((Object)value);
        }
        if (value instanceof Map) {
            return new RestEmoticon((Map)value);
        }
        return null;
    }

    public String getShortcut() {
        return this.getStringProperty(SHORTCUT);
    }

    public String getUrl() {
        return this.getStringProperty(URL);
    }

    public String getValue() {
        return this.getStringProperty(VALUE);
    }
}

