/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment.like.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.stash.internal.comment.like.Reaction;
import com.atlassian.stash.internal.comment.like.rest.RestEmoticon;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RestReaction
extends RestMapEntity {
    private static final String EMOTICON = "emoticon";
    private static final String USERS = "users";

    public RestReaction() {
    }

    public RestReaction(Reaction reaction) {
        this.put(EMOTICON, (Object)new RestEmoticon(reaction.getEmoticon()));
        this.put(USERS, reaction.getUsers().stream().map(RestApplicationUser::new).collect(Collectors.toList()));
    }

    private RestReaction(Map<String, Object> map) {
        super(map);
    }

    public RestEmoticon getEmoticon() {
        return RestEmoticon.valueOf(this.get(EMOTICON));
    }

    public List<RestApplicationUser> getUsers() {
        Object usersObject = this.get(USERS);
        if (!(usersObject instanceof List)) {
            return Collections.emptyList();
        }
        return ((List)usersObject).stream().map(RestApplicationUser::valueOf).collect(Collectors.toList());
    }

    @Nullable
    public static RestReaction valueOf(@Nullable Object value) {
        if (value instanceof RestReaction) {
            return (RestReaction)((Object)value);
        }
        if (value instanceof Map) {
            return new RestReaction((Map)value);
        }
        return null;
    }
}

