/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spring;

import com.atlassian.nutcluster.config.AdvancedNetworkConfig;
import com.atlassian.nutcluster.config.AliasedDiscoveryConfig;
import com.atlassian.nutcluster.config.AliasedDiscoveryConfigUtils;
import com.atlassian.nutcluster.config.AtomicLongConfig;
import com.atlassian.nutcluster.config.AtomicReferenceConfig;
import com.atlassian.nutcluster.config.CRDTReplicationConfig;
import com.atlassian.nutcluster.config.CachePartitionLostListenerConfig;
import com.atlassian.nutcluster.config.CacheSimpleConfig;
import com.atlassian.nutcluster.config.CacheSimpleEntryListenerConfig;
import com.atlassian.nutcluster.config.CardinalityEstimatorConfig;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigurationException;
import com.atlassian.nutcluster.config.CountDownLatchConfig;
import com.atlassian.nutcluster.config.CredentialsFactoryConfig;
import com.atlassian.nutcluster.config.DomConfigHelper;
import com.atlassian.nutcluster.config.DurableExecutorConfig;
import com.atlassian.nutcluster.config.EndpointConfig;
import com.atlassian.nutcluster.config.EntryListenerConfig;
import com.atlassian.nutcluster.config.EventJournalConfig;
import com.atlassian.nutcluster.config.ExecutorConfig;
import com.atlassian.nutcluster.config.FlakeIdGeneratorConfig;
import com.atlassian.nutcluster.config.GroupConfig;
import com.atlassian.nutcluster.config.HotRestartConfig;
import com.atlassian.nutcluster.config.HotRestartPersistenceConfig;
import com.atlassian.nutcluster.config.IcmpFailureDetectorConfig;
import com.atlassian.nutcluster.config.InMemoryFormat;
import com.atlassian.nutcluster.config.InterfacesConfig;
import com.atlassian.nutcluster.config.InvalidConfigurationException;
import com.atlassian.nutcluster.config.ItemListenerConfig;
import com.atlassian.nutcluster.config.JobTrackerConfig;
import com.atlassian.nutcluster.config.JoinConfig;
import com.atlassian.nutcluster.config.ListConfig;
import com.atlassian.nutcluster.config.ListenerConfig;
import com.atlassian.nutcluster.config.LockConfig;
import com.atlassian.nutcluster.config.LoginModuleConfig;
import com.atlassian.nutcluster.config.MCMutualAuthConfig;
import com.atlassian.nutcluster.config.ManagementCenterConfig;
import com.atlassian.nutcluster.config.MapAttributeConfig;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.config.MapIndexConfig;
import com.atlassian.nutcluster.config.MapPartitionLostListenerConfig;
import com.atlassian.nutcluster.config.MapStoreConfig;
import com.atlassian.nutcluster.config.MaxSizeConfig;
import com.atlassian.nutcluster.config.MemberAddressProviderConfig;
import com.atlassian.nutcluster.config.MemberAttributeConfig;
import com.atlassian.nutcluster.config.MemberGroupConfig;
import com.atlassian.nutcluster.config.MemcacheProtocolConfig;
import com.atlassian.nutcluster.config.MergePolicyConfig;
import com.atlassian.nutcluster.config.MerkleTreeConfig;
import com.atlassian.nutcluster.config.MultiMapConfig;
import com.atlassian.nutcluster.config.MulticastConfig;
import com.atlassian.nutcluster.config.NativeMemoryConfig;
import com.atlassian.nutcluster.config.NearCacheConfig;
import com.atlassian.nutcluster.config.NetworkConfig;
import com.atlassian.nutcluster.config.OnJoinPermissionOperationName;
import com.atlassian.nutcluster.config.PNCounterConfig;
import com.atlassian.nutcluster.config.PartitionGroupConfig;
import com.atlassian.nutcluster.config.PartitioningStrategyConfig;
import com.atlassian.nutcluster.config.PermissionConfig;
import com.atlassian.nutcluster.config.PermissionPolicyConfig;
import com.atlassian.nutcluster.config.PredicateConfig;
import com.atlassian.nutcluster.config.ProbabilisticQuorumConfigBuilder;
import com.atlassian.nutcluster.config.QueryCacheConfig;
import com.atlassian.nutcluster.config.QueueConfig;
import com.atlassian.nutcluster.config.QueueStoreConfig;
import com.atlassian.nutcluster.config.QuorumConfig;
import com.atlassian.nutcluster.config.QuorumConfigBuilder;
import com.atlassian.nutcluster.config.QuorumListenerConfig;
import com.atlassian.nutcluster.config.RecentlyActiveQuorumConfigBuilder;
import com.atlassian.nutcluster.config.ReliableTopicConfig;
import com.atlassian.nutcluster.config.ReplicatedMapConfig;
import com.atlassian.nutcluster.config.RestApiConfig;
import com.atlassian.nutcluster.config.RestEndpointGroup;
import com.atlassian.nutcluster.config.RestServerEndpointConfig;
import com.atlassian.nutcluster.config.RingbufferConfig;
import com.atlassian.nutcluster.config.RingbufferStoreConfig;
import com.atlassian.nutcluster.config.SSLConfig;
import com.atlassian.nutcluster.config.ScheduledExecutorConfig;
import com.atlassian.nutcluster.config.SecurityConfig;
import com.atlassian.nutcluster.config.SecurityInterceptorConfig;
import com.atlassian.nutcluster.config.SemaphoreConfig;
import com.atlassian.nutcluster.config.ServerSocketEndpointConfig;
import com.atlassian.nutcluster.config.ServiceConfig;
import com.atlassian.nutcluster.config.ServicesConfig;
import com.atlassian.nutcluster.config.SetConfig;
import com.atlassian.nutcluster.config.SymmetricEncryptionConfig;
import com.atlassian.nutcluster.config.TcpIpConfig;
import com.atlassian.nutcluster.config.TopicConfig;
import com.atlassian.nutcluster.config.WanConsumerConfig;
import com.atlassian.nutcluster.config.WanPublisherConfig;
import com.atlassian.nutcluster.config.WanReplicationConfig;
import com.atlassian.nutcluster.config.WanReplicationRef;
import com.atlassian.nutcluster.config.WanSyncConfig;
import com.atlassian.nutcluster.config.cp.CPSemaphoreConfig;
import com.atlassian.nutcluster.config.cp.CPSubsystemConfig;
import com.atlassian.nutcluster.config.cp.FencedLockConfig;
import com.atlassian.nutcluster.config.cp.RaftAlgorithmConfig;
import com.atlassian.nutcluster.instance.EndpointQualifier;
import com.atlassian.nutcluster.instance.ProtocolType;
import com.atlassian.nutcluster.map.eviction.MapEvictionPolicy;
import com.atlassian.nutcluster.memory.MemorySize;
import com.atlassian.nutcluster.memory.MemoryUnit;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.quorum.QuorumType;
import com.atlassian.nutcluster.spi.ServiceConfigurationParser;
import com.atlassian.nutcluster.spring.AbstractNutclusterBeanDefinitionParser;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NutclusterConfigBeanDefinitionParser
extends AbstractNutclusterBeanDefinitionParser {
    public AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(this, parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    private class SpringXmlConfigBuilder
    extends AbstractNutclusterBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private ManagedMap<String, AbstractBeanDefinition> mapConfigManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cacheConfigManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> queueManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> lockManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> ringbufferManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> atomicLongManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> atomicReferenceManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> countDownLatchManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> reliableTopicManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> semaphoreManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> listManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> setManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> topicManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> multiMapManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> executorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> durableExecutorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> scheduledExecutorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> mapEventJournalManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cacheEventJournalManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> mapMerkleTreeManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cardinalityEstimatorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> wanReplicationManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> jobTrackerManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> replicatedMapManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> quorumManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> flakeIdGeneratorConfigMap;
        private ManagedMap<String, AbstractBeanDefinition> pnCounterManagedMap;
        private ManagedMap<EndpointQualifier, AbstractBeanDefinition> endpointConfigsMap;
        private boolean hasNetwork;
        private boolean hasAdvancedNetworkEnabled;

        public SpringXmlConfigBuilder(NutclusterConfigBeanDefinitionParser nutclusterConfigBeanDefinitionParser, ParserContext parserContext) {
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(Config.class);
            this.mapConfigManagedMap = this.createManagedMap("mapConfigs");
            this.cacheConfigManagedMap = this.createManagedMap("cacheConfigs");
            this.queueManagedMap = this.createManagedMap("queueConfigs");
            this.lockManagedMap = this.createManagedMap("lockConfigs");
            this.ringbufferManagedMap = this.createManagedMap("ringbufferConfigs");
            this.atomicLongManagedMap = this.createManagedMap("atomicLongConfigs");
            this.atomicReferenceManagedMap = this.createManagedMap("atomicReferenceConfigs");
            this.countDownLatchManagedMap = this.createManagedMap("countDownLatchConfigs");
            this.reliableTopicManagedMap = this.createManagedMap("reliableTopicConfigs");
            this.semaphoreManagedMap = this.createManagedMap("semaphoreConfigs");
            this.listManagedMap = this.createManagedMap("listConfigs");
            this.setManagedMap = this.createManagedMap("setConfigs");
            this.topicManagedMap = this.createManagedMap("topicConfigs");
            this.multiMapManagedMap = this.createManagedMap("multiMapConfigs");
            this.executorManagedMap = this.createManagedMap("executorConfigs");
            this.durableExecutorManagedMap = this.createManagedMap("durableExecutorConfigs");
            this.scheduledExecutorManagedMap = this.createManagedMap("scheduledExecutorConfigs");
            this.mapEventJournalManagedMap = this.createManagedMap("mapEventJournalConfigs");
            this.cacheEventJournalManagedMap = this.createManagedMap("cacheEventJournalConfigs");
            this.mapMerkleTreeManagedMap = this.createManagedMap("mapMerkleTreeConfigs");
            this.cardinalityEstimatorManagedMap = this.createManagedMap("cardinalityEstimatorConfigs");
            this.wanReplicationManagedMap = this.createManagedMap("wanReplicationConfigs");
            this.jobTrackerManagedMap = this.createManagedMap("jobTrackerConfigs");
            this.replicatedMapManagedMap = this.createManagedMap("replicatedMapConfigs");
            this.quorumManagedMap = this.createManagedMap("quorumConfigs");
            this.flakeIdGeneratorConfigMap = this.createManagedMap("flakeIdGeneratorConfigs");
            this.pnCounterManagedMap = this.createManagedMap("PNCounterConfigs");
            this.endpointConfigsMap = new ManagedMap();
        }

        private ManagedMap<String, AbstractBeanDefinition> createManagedMap(String configName) {
            ManagedMap managedMap = new ManagedMap();
            this.configBuilder.addPropertyValue(configName, (Object)managedMap);
            return managedMap;
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        public void handleConfig(Element element) {
            if (element != null) {
                this.handleCommonBeanAttributes(element, this.configBuilder, this.parserContext);
                for (Node node : DomConfigHelper.childElements((Node)element)) {
                    String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                    if ("network".equals(nodeName)) {
                        this.handleNetwork(node);
                        continue;
                    }
                    if ("advanced-network".equals(nodeName)) {
                        this.handleAdvancedNetwork(node);
                        continue;
                    }
                    if ("group".equals(nodeName)) {
                        this.handleGroup(node);
                        continue;
                    }
                    if ("properties".equals(nodeName)) {
                        this.handleProperties(node);
                        continue;
                    }
                    if ("executor-service".equals(nodeName)) {
                        this.handleExecutor(node);
                        continue;
                    }
                    if ("durable-executor-service".equals(nodeName)) {
                        this.handleDurableExecutor(node);
                        continue;
                    }
                    if ("scheduled-executor-service".equals(nodeName)) {
                        this.handleScheduledExecutor(node);
                        continue;
                    }
                    if ("event-journal".equals(nodeName)) {
                        this.handleEventJournal(node);
                        continue;
                    }
                    if ("merkle-tree".equals(nodeName)) {
                        this.handleMerkleTree(node);
                        continue;
                    }
                    if ("cardinality-estimator".equals(nodeName)) {
                        this.handleCardinalityEstimator(node);
                        continue;
                    }
                    if ("queue".equals(nodeName)) {
                        this.handleQueue(node);
                        continue;
                    }
                    if ("lock".equals(nodeName)) {
                        this.handleLock(node);
                        continue;
                    }
                    if ("ringbuffer".equals(nodeName)) {
                        this.handleRingbuffer(node);
                        continue;
                    }
                    if ("atomic-long".equals(nodeName)) {
                        this.handleAtomicLong(node);
                        continue;
                    }
                    if ("atomic-reference".equals(nodeName)) {
                        this.handleAtomicReference(node);
                        continue;
                    }
                    if ("count-down-latch".equals(nodeName)) {
                        this.handleCountDownLatch(node);
                        continue;
                    }
                    if ("reliable-topic".equals(nodeName)) {
                        this.handleReliableTopic(node);
                        continue;
                    }
                    if ("semaphore".equals(nodeName)) {
                        this.handleSemaphore(node);
                        continue;
                    }
                    if ("map".equals(nodeName)) {
                        this.handleMap(node);
                        continue;
                    }
                    if ("cache".equals(nodeName)) {
                        this.handleCache(node);
                        continue;
                    }
                    if ("multimap".equals(nodeName)) {
                        this.handleMultiMap(node);
                        continue;
                    }
                    if ("list".equals(nodeName)) {
                        this.handleList(node);
                        continue;
                    }
                    if ("set".equals(nodeName)) {
                        this.handleSet(node);
                        continue;
                    }
                    if ("topic".equals(nodeName)) {
                        this.handleTopic(node);
                        continue;
                    }
                    if ("jobtracker".equals(nodeName)) {
                        this.handleJobTracker(node);
                        continue;
                    }
                    if ("replicatedmap".equals(nodeName)) {
                        this.handleReplicatedMap(node);
                        continue;
                    }
                    if ("wan-replication".equals(nodeName)) {
                        this.handleWanReplication(node);
                        continue;
                    }
                    if ("partition-group".equals(nodeName)) {
                        this.handlePartitionGroup(node);
                        continue;
                    }
                    if ("serialization".equals(nodeName)) {
                        this.handleSerialization(node);
                        continue;
                    }
                    if ("native-memory".equals(nodeName)) {
                        this.handleNativeMemory(node);
                        continue;
                    }
                    if ("security".equals(nodeName)) {
                        this.handleSecurity(node);
                        continue;
                    }
                    if ("member-attributes".equals(nodeName)) {
                        this.handleMemberAttributes(node);
                        continue;
                    }
                    if ("instance-name".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("listeners".equals(nodeName)) {
                        ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                        this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                        continue;
                    }
                    if ("lite-member".equals(nodeName)) {
                        this.handleLiteMember(node);
                        continue;
                    }
                    if ("license-key".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("management-center".equals(nodeName)) {
                        this.handleManagementCenter(node);
                        continue;
                    }
                    if ("services".equals(nodeName)) {
                        this.handleServices(node);
                        continue;
                    }
                    if ("spring-aware".equals(nodeName)) {
                        this.handleSpringAware();
                        continue;
                    }
                    if ("quorum".equals(nodeName)) {
                        this.handleQuorum(node);
                        continue;
                    }
                    if ("hot-restart-persistence".equals(nodeName)) {
                        this.handleHotRestartPersistence(node);
                        continue;
                    }
                    if ("flake-id-generator".equals(nodeName)) {
                        this.handleFlakeIdGenerator(node);
                        continue;
                    }
                    if ("crdt-replication".equals(nodeName)) {
                        this.handleCRDTReplication(node);
                        continue;
                    }
                    if ("pn-counter".equals(nodeName)) {
                        this.handlePNCounter(node);
                        continue;
                    }
                    if (!"cp-subsystem".equals(nodeName)) continue;
                    this.handleCPSubSystem(node);
                }
            }
            if (this.hasNetwork && this.hasAdvancedNetworkEnabled) {
                throw new InvalidConfigurationException("Ambiguous configuration: cannot include both <network> and an enabled <advanced-network> element. Configure network using one of <network> or <advanced-network enabled=\"true\">.");
            }
        }

        private void handleHotRestartPersistence(Node node) {
            BeanDefinitionBuilder hotRestartConfigBuilder = this.createBeanBuilder(HotRestartPersistenceConfig.class);
            this.fillAttributeValues(node, hotRestartConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("base-dir".equals(name)) {
                    String value = this.getTextContent(child);
                    hotRestartConfigBuilder.addPropertyValue("baseDir", (Object)value);
                    continue;
                }
                if (!"backup-dir".equals(name)) continue;
                hotRestartConfigBuilder.addPropertyValue("backupDir", (Object)this.getTextContent(child));
            }
            this.configBuilder.addPropertyValue("hotRestartPersistenceConfig", (Object)hotRestartConfigBuilder.getBeanDefinition());
        }

        private void handleFlakeIdGenerator(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(FlakeIdGeneratorConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            String name = this.getAttribute(node, "name");
            this.flakeIdGeneratorConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleCRDTReplication(Node node) {
            BeanDefinitionBuilder crdtReplicationConfigBuilder = this.createBeanBuilder(CRDTReplicationConfig.class);
            this.fillAttributeValues(node, crdtReplicationConfigBuilder, new String[0]);
            this.configBuilder.addPropertyValue("CRDTReplicationConfig", (Object)crdtReplicationConfigBuilder.getBeanDefinition());
        }

        private void handleCPSubSystem(Node node) {
            BeanDefinitionBuilder cpSubsystemConfigBuilder = this.createBeanBuilder(CPSubsystemConfig.class);
            this.fillValues(node, cpSubsystemConfigBuilder, "raftAlgorithm", "semaphores", "locks", "cpMemberCount", "missingCpMemberAutoRemovalSeconds");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("raft-algorithm".equals(nodeName)) {
                    BeanDefinitionBuilder raftAlgorithmConfigBuilder = this.createBeanBuilder(RaftAlgorithmConfig.class);
                    this.fillValues(child, raftAlgorithmConfigBuilder, new String[0]);
                    cpSubsystemConfigBuilder.addPropertyValue("raftAlgorithmConfig", (Object)raftAlgorithmConfigBuilder.getBeanDefinition());
                    continue;
                }
                if ("semaphores".equals(nodeName)) {
                    ManagedMap semaphores = new ManagedMap();
                    this.handleCPSemaphores((ManagedMap<String, AbstractBeanDefinition>)semaphores, child);
                    cpSubsystemConfigBuilder.addPropertyValue("SemaphoreConfigs", (Object)semaphores);
                    continue;
                }
                if ("locks".equals(nodeName)) {
                    ManagedMap locks = new ManagedMap();
                    this.handleFencedLocks((ManagedMap<String, AbstractBeanDefinition>)locks, child);
                    cpSubsystemConfigBuilder.addPropertyValue("LockConfigs", (Object)locks);
                    continue;
                }
                String value = this.getTextContent(child).trim();
                if ("cp-member-count".equals(nodeName)) {
                    cpSubsystemConfigBuilder.addPropertyValue("CPMemberCount", (Object)DomConfigHelper.getIntegerValue((String)"cp-member-count", (String)value));
                    continue;
                }
                if (!"missing-cp-member-auto-removal-seconds".equals(nodeName)) continue;
                cpSubsystemConfigBuilder.addPropertyValue("missingCPMemberAutoRemovalSeconds", (Object)DomConfigHelper.getIntegerValue((String)"missing-cp-member-auto-removal-seconds", (String)value));
            }
            this.configBuilder.addPropertyValue("CPSubsystemConfig", (Object)cpSubsystemConfigBuilder.getBeanDefinition());
        }

        private void handleCPSemaphores(ManagedMap<String, AbstractBeanDefinition> cpSemaphores, Node node) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder cpSemaphoreConfigBuilder = this.createBeanBuilder(CPSemaphoreConfig.class);
                for (Node subChild : DomConfigHelper.childElements((Node)child)) {
                    String nodeName = DomConfigHelper.cleanNodeName((Node)subChild);
                    String value = this.getTextContent(subChild).trim();
                    if ("name".equals(nodeName)) {
                        cpSemaphoreConfigBuilder.addPropertyValue("name", (Object)value);
                        continue;
                    }
                    if (!"jdk-compatible".equals(nodeName)) continue;
                    cpSemaphoreConfigBuilder.addPropertyValue("JDKCompatible", (Object)DomConfigHelper.getBooleanValue((String)value));
                }
                AbstractBeanDefinition beanDefinition = cpSemaphoreConfigBuilder.getBeanDefinition();
                String name = (String)beanDefinition.getPropertyValues().get("name");
                cpSemaphores.put((Object)name, (Object)beanDefinition);
            }
        }

        private void handleFencedLocks(ManagedMap<String, AbstractBeanDefinition> locks, Node node) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder lockConfigBuilder = this.createBeanBuilder(FencedLockConfig.class);
                this.fillValues(child, lockConfigBuilder, new String[0]);
                AbstractBeanDefinition beanDefinition = lockConfigBuilder.getBeanDefinition();
                String name = (String)beanDefinition.getPropertyValues().get("name");
                locks.put((Object)name, (Object)beanDefinition);
            }
        }

        private void handleQuorum(Node node) {
            BeanDefinitionBuilder quorumConfigBuilder = this.createBeanBuilder(QuorumConfig.class);
            AbstractBeanDefinition beanDefinition = quorumConfigBuilder.getBeanDefinition();
            String name = this.getAttribute(node, "name");
            quorumConfigBuilder.addPropertyValue("name", (Object)name);
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue((String)this.getTextContent(attrEnabled));
            quorumConfigBuilder.addPropertyValue("enabled", (Object)enabled);
            QuorumConfigBuilder configBuilder = null;
            int quorumSize = 3;
            String quorumClassName = null;
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String value = this.getTextContent(n).trim();
                String nodeName = DomConfigHelper.cleanNodeName((Node)n);
                if ("quorum-size".equals(nodeName)) {
                    quorumConfigBuilder.addPropertyValue("size", (Object)DomConfigHelper.getIntegerValue((String)"quorum-size", (String)value));
                    continue;
                }
                if ("quorum-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(n, QuorumListenerConfig.class);
                    quorumConfigBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-type".equals(nodeName)) {
                    quorumConfigBuilder.addPropertyValue("type", (Object)QuorumType.valueOf((String)value));
                    continue;
                }
                if ("quorum-function-class-name".equals(nodeName)) {
                    quorumClassName = value;
                    quorumConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)value);
                    continue;
                }
                if ("recently-active-quorum".equals(nodeName)) {
                    configBuilder = this.handleRecentlyActiveQuorum(name, n, quorumSize);
                    continue;
                }
                if (!"probabilistic-quorum".equals(nodeName)) continue;
                configBuilder = this.handleProbabilisticQuorum(name, n, quorumSize);
            }
            if (configBuilder != null) {
                boolean quorumFunctionDefinedByClassName;
                boolean bl = quorumFunctionDefinedByClassName = !StringUtil.isNullOrEmpty(quorumClassName);
                if (quorumFunctionDefinedByClassName) {
                    throw new ConfigurationException("A quorum cannot simultaneously define probabilistic-quorum or recently-active-quorum and a quorum function class name.");
                }
                QuorumConfig constructedConfig = configBuilder.build();
                quorumConfigBuilder.addPropertyValue("quorumFunctionImplementation", (Object)constructedConfig.getQuorumFunctionImplementation());
            }
            this.quorumManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private QuorumConfigBuilder handleRecentlyActiveQuorum(String name, Node node, int quorumSize) {
            int heartbeatToleranceMillis = DomConfigHelper.getIntegerValue((String)"heartbeat-tolerance-millis", (String)this.getAttribute(node, "heartbeat-tolerance-millis"), (int)RecentlyActiveQuorumConfigBuilder.DEFAULT_HEARTBEAT_TOLERANCE_MILLIS);
            RecentlyActiveQuorumConfigBuilder quorumConfigBuilder = QuorumConfig.newRecentlyActiveQuorumConfigBuilder((String)name, (int)quorumSize, (int)heartbeatToleranceMillis);
            return quorumConfigBuilder;
        }

        private QuorumConfigBuilder handleProbabilisticQuorum(String name, Node node, int quorumSize) {
            long acceptableHeartPause = DomConfigHelper.getLongValue((String)"acceptable-heartbeat-pause-millis", (String)this.getAttribute(node, "acceptable-heartbeat-pause-millis"), (long)ProbabilisticQuorumConfigBuilder.DEFAULT_HEARTBEAT_PAUSE_MILLIS);
            double threshold = DomConfigHelper.getDoubleValue((String)"suspicion-threshold", (String)this.getAttribute(node, "suspicion-threshold"), (double)ProbabilisticQuorumConfigBuilder.DEFAULT_PHI_THRESHOLD);
            int maxSampleSize = DomConfigHelper.getIntegerValue((String)"max-sample-size", (String)this.getAttribute(node, "max-sample-size"), (int)ProbabilisticQuorumConfigBuilder.DEFAULT_SAMPLE_SIZE);
            long minStdDeviation = DomConfigHelper.getLongValue((String)"min-std-deviation-millis", (String)this.getAttribute(node, "min-std-deviation-millis"), (long)ProbabilisticQuorumConfigBuilder.DEFAULT_MIN_STD_DEVIATION);
            long heartbeatIntervalMillis = DomConfigHelper.getLongValue((String)"heartbeat-interval-millis", (String)this.getAttribute(node, "heartbeat-interval-millis"), (long)ProbabilisticQuorumConfigBuilder.DEFAULT_HEARTBEAT_INTERVAL_MILLIS);
            ProbabilisticQuorumConfigBuilder quorumConfigBuilder = QuorumConfig.newProbabilisticQuorumConfigBuilder((String)name, (int)quorumSize).withAcceptableHeartbeatPauseMillis(acceptableHeartPause).withSuspicionThreshold(threshold).withHeartbeatIntervalMillis(heartbeatIntervalMillis).withMinStdDeviationMillis(minStdDeviation).withMaxSampleSize(maxSampleSize);
            return quorumConfigBuilder;
        }

        private void handleMergePolicyConfig(Node node, BeanDefinitionBuilder builder) {
            BeanDefinitionBuilder mergePolicyConfigBuilder = this.createBeanBuilder(MergePolicyConfig.class);
            AbstractBeanDefinition beanDefinition = mergePolicyConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, mergePolicyConfigBuilder, new String[0]);
            mergePolicyConfigBuilder.addPropertyValue("policy", (Object)this.getTextContent(node).trim());
            builder.addPropertyValue("mergePolicyConfig", (Object)beanDefinition);
        }

        private void handleLiteMember(Node node) {
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            this.configBuilder.addPropertyValue(this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)node)), (Object)this.getTextContent(attrEnabled));
        }

        public void handleServices(Node node) {
            BeanDefinitionBuilder servicesConfigBuilder = this.createBeanBuilder(ServicesConfig.class);
            AbstractBeanDefinition beanDefinition = servicesConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, servicesConfigBuilder, new String[0]);
            ManagedList serviceConfigManagedList = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"service".equals(nodeName)) continue;
                serviceConfigManagedList.add((Object)this.handleService(child));
            }
            servicesConfigBuilder.addPropertyValue("serviceConfigs", (Object)serviceConfigManagedList);
            this.configBuilder.addPropertyValue("servicesConfig", (Object)beanDefinition);
        }

        private AbstractBeanDefinition handleService(Node node) {
            Node implNode;
            BeanDefinitionBuilder serviceConfigBuilder = this.createBeanBuilder(ServiceConfig.class);
            AbstractBeanDefinition beanDefinition = serviceConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, serviceConfigBuilder, new String[0]);
            boolean classNameSet = false;
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    continue;
                }
                if ("class-name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    classNameSet = true;
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(child, serviceConfigBuilder);
                    continue;
                }
                if (!"configuration".equals(nodeName)) continue;
                Node parser = child.getAttributes().getNamedItem("parser");
                String name = this.getTextContent(parser);
                try {
                    ServiceConfigurationParser serviceConfigurationParser = (ServiceConfigurationParser)ClassLoaderUtil.newInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)name);
                    Object obj = serviceConfigurationParser.parse((Element)child);
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName("config-object"), obj);
                }
                catch (Exception e) {
                    ExceptionUtil.sneakyThrow((Throwable)e);
                }
            }
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            if (classNameNode != null) {
                serviceConfigBuilder.addPropertyValue("className", (Object)this.getTextContent(classNameNode));
            }
            if ((implNode = attributes.getNamedItem("implementation")) != null) {
                serviceConfigBuilder.addPropertyReference("implementation", this.getTextContent(implNode));
            }
            Assert.isTrue((classNameSet || classNameNode != null || implNode != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create ServiceConfig!");
            return beanDefinition;
        }

        public void handleReplicatedMap(Node node) {
            BeanDefinitionBuilder replicatedMapConfigBuilder = this.createBeanBuilder(ReplicatedMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, replicatedMapConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    replicatedMapConfigBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    replicatedMapConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, replicatedMapConfigBuilder);
            }
            this.replicatedMapManagedMap.put((Object)name, (Object)replicatedMapConfigBuilder.getBeanDefinition());
        }

        public void handleNetwork(Node node) {
            this.hasNetwork = true;
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class);
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, networkConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, networkConfigBuilder);
                    continue;
                }
                if ("reuse-address".equals(nodeName)) {
                    this.handleReuseAddress(child, networkConfigBuilder);
                    continue;
                }
                if ("member-address-provider".equals(nodeName)) {
                    this.handleMemberAddressProvider(child, networkConfigBuilder);
                    continue;
                }
                if ("failure-detector".equals(nodeName)) {
                    this.handleFailureDetector(child, networkConfigBuilder);
                    continue;
                }
                if ("rest-api".equals(nodeName)) {
                    this.handleRestApi(child, networkConfigBuilder);
                    continue;
                }
                if (!"memcache-protocol".equals(nodeName)) continue;
                this.handleMemcacheProtocol(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        void handleAdvancedNetwork(Node node) {
            BeanDefinitionBuilder advNetworkConfigBuilder = this.createBeanBuilder(AdvancedNetworkConfig.class);
            AbstractBeanDefinition beanDefinition = advNetworkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, advNetworkConfigBuilder, new String[0]);
            String enabled = this.getAttribute(node, "enabled");
            if (DomConfigHelper.getBooleanValue((String)enabled)) {
                this.hasAdvancedNetworkEnabled = true;
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, advNetworkConfigBuilder);
                    continue;
                }
                if ("member-address-provider".equals(nodeName)) {
                    this.handleMemberAddressProvider(child, advNetworkConfigBuilder);
                    continue;
                }
                if ("failure-detector".equals(nodeName)) {
                    this.handleFailureDetector(child, advNetworkConfigBuilder);
                    continue;
                }
                if ("wan-endpoint-config".equals(nodeName)) {
                    this.handleWanEndpointConfig(child);
                    continue;
                }
                if ("member-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleMemberServerSocketEndpointConfig(child);
                    continue;
                }
                if ("client-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleClientServerSocketEndpointConfig(child);
                    continue;
                }
                if ("wan-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleWanServerSocketEndpointConfig(child);
                    continue;
                }
                if ("rest-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleRestServerSocketEndpointConfig(child);
                    continue;
                }
                if (!"memcache-server-socket-endpoint-config".equals(nodeName)) continue;
                this.handleMemcacheServerSocketEndpointConfig(child);
            }
            advNetworkConfigBuilder.addPropertyValue("endpointConfigs", this.endpointConfigsMap);
            this.configBuilder.addPropertyValue("advancedNetworkConfig", (Object)beanDefinition);
        }

        void handleWanEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(EndpointConfig.class);
            this.handleEndpointConfig(node, ProtocolType.WAN, endpointConfigBuilder);
        }

        void handleEndpointConfig(Node node, ProtocolType type, BeanDefinitionBuilder endpointConfigBuilder) {
            AbstractBeanDefinition beanDefinition = endpointConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, endpointConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                this.handleEndpointConfigCommons(child, endpointConfigBuilder);
            }
            this.endpointConfigsMap.put((Object)this.createEndpointQualifier(type, node), (Object)beanDefinition);
        }

        private void handleEndpointConfigCommons(Node node, BeanDefinitionBuilder endpointConfigBuilder) {
            String nodeName = DomConfigHelper.cleanNodeName((Node)node);
            if ("outbound-ports".equals(nodeName)) {
                this.handleOutboundPorts(node, endpointConfigBuilder);
            } else if ("interfaces".equals(nodeName)) {
                this.handleInterfaces(node, endpointConfigBuilder);
            } else if ("symmetric-encryption".equals(nodeName)) {
                this.handleSymmetricEncryption(node, endpointConfigBuilder);
            } else if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(node, endpointConfigBuilder);
            } else if ("socket-interceptor".equals(nodeName)) {
                this.handleSocketInterceptorConfig(node, endpointConfigBuilder);
            } else if ("socket-options".equals(nodeName)) {
                this.handleEndpointSocketOptions(node, endpointConfigBuilder);
            }
        }

        void handleMemberServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.MEMBER, endpointConfigBuilder);
        }

        void handleClientServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.CLIENT, endpointConfigBuilder);
        }

        void handleWanServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.WAN, endpointConfigBuilder);
        }

        void handleRestServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(RestServerEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.REST, endpointConfigBuilder);
            ManagedSet groupSet = new ManagedSet();
            for (RestEndpointGroup group : RestEndpointGroup.values()) {
                if (!group.isEnabledByDefault()) continue;
                groupSet.add((Object)group);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"endpoint-groups".equals(nodeName)) continue;
                this.handleRestEndpointGroup(node, endpointConfigBuilder, (ManagedSet<RestEndpointGroup>)groupSet);
            }
        }

        void handleMemcacheServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.MEMCACHE, endpointConfigBuilder);
        }

        void handleServerSocketEndpointConfig(Node node, ProtocolType type, BeanDefinitionBuilder endpointBuilder) {
            AbstractBeanDefinition beanDefinition = endpointBuilder.getBeanDefinition();
            this.fillAttributeValues(node, endpointBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("reuse-address".equals(nodeName)) {
                    String value = this.getTextContent(child).trim();
                    endpointBuilder.addPropertyValue("reuseAddress", (Object)value);
                    continue;
                }
                this.handleEndpointConfigCommons(child, endpointBuilder);
            }
            this.endpointConfigsMap.put((Object)this.createEndpointQualifier(type, node), (Object)beanDefinition);
        }

        void handleEndpointSocketOptions(Node node, BeanDefinitionBuilder endpointConfigBuilder) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                String textContent = this.getTextContent(child);
                if ("buffer-direct".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketBufferDirect", (Object)DomConfigHelper.getBooleanValue((String)textContent));
                    continue;
                }
                if ("tcp-no-delay".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketTcpNoDelay", (Object)DomConfigHelper.getBooleanValue((String)textContent));
                    continue;
                }
                if ("keep-alive".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketKeepAlive", (Object)DomConfigHelper.getBooleanValue((String)textContent));
                    continue;
                }
                if ("connect-timeout-seconds".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketConnectTimeoutSeconds", (Object)DomConfigHelper.getIntegerValue((String)"socketConnectTimeoutSeconds", (String)textContent));
                    continue;
                }
                if ("send-buffer-size-kb".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketSendBufferSizeKb", (Object)DomConfigHelper.getIntegerValue((String)"socketSendBufferSizeKb", (String)textContent));
                    continue;
                }
                if ("receive-buffer-size-kb".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketRcvBufferSizeKb", (Object)DomConfigHelper.getIntegerValue((String)"socketRcvBufferSizeKb", (String)textContent));
                    continue;
                }
                if (!"linger-seconds".equals(nodeName)) continue;
                endpointConfigBuilder.addPropertyValue("socketLingerSeconds", (Object)DomConfigHelper.getIntegerValue((String)"socketLingerSeconds", (String)textContent));
            }
        }

        public void handleGroup(Node node) {
            this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(InterfacesConfig.class);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node att = attributes.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interfacesSet = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)n));
                String value = this.getTextContent(n);
                if (!"interface".equals(name)) continue;
                interfacesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interfacesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(JoinConfig.class);
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if ("tcp-ip".equals(name)) {
                    this.handleTcpIp(child, joinConfigBuilder);
                    continue;
                }
                if (AliasedDiscoveryConfigUtils.supports((String)name)) {
                    this.handleAliasedDiscoveryStrategy(child, joinConfigBuilder, name);
                    continue;
                }
                if (!"discovery-strategies".equals(name)) continue;
                this.handleDiscoveryStrategies(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }

        private void handleReuseAddress(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String value = node.getTextContent();
            networkConfigBuilder.addPropertyValue("reuseAddress", (Object)value);
        }

        private void handleMemberAddressProvider(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder memberAddressProviderConfigBuilder = this.createBeanBuilder(MemberAddressProviderConfig.class);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, memberAddressProviderConfigBuilder);
                break;
            }
            String implementationAttr = "implementation";
            String classNameAttr = "class-name";
            String implementationValue = this.getAttribute(node, implementationAttr);
            String classNameValue = this.getAttribute(node, classNameAttr);
            memberAddressProviderConfigBuilder.addPropertyValue("enabled", (Object)DomConfigHelper.getBooleanValue((String)this.getAttribute(node, "enabled")));
            if (!StringUtil.isNullOrEmpty((String)implementationValue)) {
                memberAddressProviderConfigBuilder.addPropertyReference(implementationAttr, implementationValue);
            } else {
                if (StringUtil.isNullOrEmpty((String)classNameValue)) {
                    throw new InvalidConfigurationException("One of the \"class-name\" or \"implementation\" configuration is needed for member address provider configuration");
                }
                memberAddressProviderConfigBuilder.addPropertyValue("className", (Object)classNameValue);
            }
            networkConfigBuilder.addPropertyValue("memberAddressProviderConfig", (Object)memberAddressProviderConfigBuilder.getBeanDefinition());
        }

        private void handleFailureDetector(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            if (!node.hasChildNodes()) {
                return;
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!DomConfigHelper.cleanNodeName((Node)child).equals("icmp")) {
                    throw new IllegalStateException("Unsupported child under Failure-Detector");
                }
                Node enabledNode = child.getAttributes().getNamedItem("enabled");
                boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue((String)this.getTextContent(enabledNode));
                BeanDefinitionBuilder icmpFailureDetectorConfigBuilder = this.createBeanBuilder(IcmpFailureDetectorConfig.class);
                icmpFailureDetectorConfigBuilder.addPropertyValue("enabled", (Object)enabled);
                for (Node n : DomConfigHelper.childElements((Node)child)) {
                    String nodeName = DomConfigHelper.cleanNodeName((Node)n);
                    if (nodeName.equals("ttl")) {
                        int ttl = Integer.parseInt(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("ttl", (Object)ttl);
                        continue;
                    }
                    if (nodeName.equals("timeout-milliseconds")) {
                        int timeout = Integer.parseInt(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("timeoutMilliseconds", (Object)timeout);
                        continue;
                    }
                    if (nodeName.equals("parallel-mode")) {
                        boolean mode = Boolean.parseBoolean(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("parallelMode", (Object)mode);
                        continue;
                    }
                    if (nodeName.equals("fail-fast-on-startup")) {
                        boolean failOnStartup = Boolean.parseBoolean(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("failFastOnStartup", (Object)failOnStartup);
                        continue;
                    }
                    if (nodeName.equals("max-attempts")) {
                        int attempts = Integer.parseInt(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("maxAttempts", (Object)attempts);
                        continue;
                    }
                    if (!nodeName.equals("interval-milliseconds")) continue;
                    int interval = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfigBuilder.addPropertyValue("intervalMilliseconds", (Object)interval);
                }
                networkConfigBuilder.addPropertyValue("icmpFailureDetectorConfig", (Object)icmpFailureDetectorConfigBuilder.getBeanDefinition());
            }
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            this.createAndFillListedBean(node, ExecutorConfig.class, "name", this.executorManagedMap, new String[0]);
        }

        public void handleDurableExecutor(Node node) {
            this.createAndFillListedBean(node, DurableExecutorConfig.class, "name", this.durableExecutorManagedMap, new String[0]);
        }

        public void handleScheduledExecutor(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, ScheduledExecutorConfig.class, "name", this.scheduledExecutorManagedMap, "mergePolicy");
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"merge-policy".equals(name)) continue;
                this.handleMergePolicyConfig(n, builder);
            }
        }

        public void handleCardinalityEstimator(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, CardinalityEstimatorConfig.class, "name", this.cardinalityEstimatorManagedMap, "mergePolicy");
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"merge-policy".equals(name)) continue;
                this.handleMergePolicyConfig(n, builder);
            }
        }

        public void handlePNCounter(Node node) {
            this.createAndFillListedBean(node, PNCounterConfig.class, "name", this.pnCounterManagedMap, new String[0]);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, MulticastConfig.class, "multicastConfig", joinConfigBuilder, "trusted-interfaces", "interface");
            ManagedList interfaces = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"trusted-interfaces".equals(name)) continue;
                for (Node i : DomConfigHelper.childElements((Node)n)) {
                    name = DomConfigHelper.cleanNodeName((Node)i);
                    if (!"interface".equals(name)) continue;
                    String value = this.getTextContent(i);
                    interfaces.add((Object)value);
                }
            }
            builder.addPropertyValue("trustedInterfaces", (Object)interfaces);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            ManagedList members = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"member".equals(name) && !"members".equals(name) && !"interface".equals(name)) continue;
                String value = this.getTextContent(n);
                members.add((Object)value);
            }
            builder.addPropertyValue("members", (Object)members);
        }

        private void handleAliasedDiscoveryStrategy(Node node, BeanDefinitionBuilder builder, String name) {
            AliasedDiscoveryConfig config = AliasedDiscoveryConfigUtils.newConfigFor((String)name);
            this.fillAttributesForAliasedDiscoveryStrategy(config, node, builder, name);
        }

        public void handleReliableTopic(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(ReliableTopicConfig.class);
            this.fillAttributeValues(node, builder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                if (!"message-listeners".equals(DomConfigHelper.cleanNodeName((Node)childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ListenerConfig.class);
                builder.addPropertyValue("messageListenerConfigs", (Object)listeners);
            }
            this.reliableTopicManagedMap.put((Object)this.getAttribute(node, "name"), (Object)builder.getBeanDefinition());
        }

        public void handleSemaphore(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(SemaphoreConfig.class);
            this.fillAttributeValues(node, builder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if (!"quorum-ref".equals(nodeName)) continue;
                builder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.semaphoreManagedMap.put((Object)this.getAttribute(node, "name"), (Object)builder.getBeanDefinition());
        }

        public void handleLock(Node node) {
            BeanDefinitionBuilder lockConfigBuilder = this.createBeanBuilder(LockConfig.class);
            this.fillAttributeValues(node, lockConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if (!"quorum-ref".equals(nodeName)) continue;
                lockConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.lockManagedMap.put((Object)this.getAttribute(node, "name"), (Object)lockConfigBuilder.getBeanDefinition());
        }

        public void handleMerkleTree(Node node) {
            BeanDefinitionBuilder merkleTreeBuilder = this.createBeanBuilder(MerkleTreeConfig.class);
            this.fillAttributeValues(node, merkleTreeBuilder, new String[0]);
            String mapName = this.getAttribute(node, "map-name");
            this.mapMerkleTreeManagedMap.put((Object)mapName, (Object)merkleTreeBuilder.getBeanDefinition());
        }

        public void handleEventJournal(Node node) {
            BeanDefinitionBuilder eventJournalBuilder = this.createBeanBuilder(EventJournalConfig.class);
            this.fillAttributeValues(node, eventJournalBuilder, new String[0]);
            String mapName = this.getAttribute(node, "map-name");
            String cacheName = this.getAttribute(node, "cache-name");
            if (!StringUtil.isNullOrEmpty((String)mapName)) {
                this.mapEventJournalManagedMap.put((Object)mapName, (Object)eventJournalBuilder.getBeanDefinition());
            }
            if (!StringUtil.isNullOrEmpty((String)cacheName)) {
                this.cacheEventJournalManagedMap.put((Object)cacheName, (Object)eventJournalBuilder.getBeanDefinition());
            }
        }

        public void handleRingbuffer(Node node) {
            BeanDefinitionBuilder ringbufferConfigBuilder = this.createBeanBuilder(RingbufferConfig.class);
            this.fillAttributeValues(node, ringbufferConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("ringbuffer-store".equals(nodeName)) {
                    this.handleRingbufferStoreConfig(childNode, ringbufferConfigBuilder);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    ringbufferConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, ringbufferConfigBuilder);
            }
            this.ringbufferManagedMap.put((Object)this.getAttribute(node, "name"), (Object)ringbufferConfigBuilder.getBeanDefinition());
        }

        public void handleRingbufferStoreConfig(Node node, BeanDefinitionBuilder ringbufferConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(RingbufferStoreConfig.class);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, builder);
                break;
            }
            this.extractBasicStoreConfig(node, builder);
            ringbufferConfigBuilder.addPropertyValue("ringbufferStoreConfig", (Object)builder.getBeanDefinition());
        }

        public void handleAtomicLong(Node node) {
            BeanDefinitionBuilder atomicLongConfigBuilder = this.createBeanBuilder(AtomicLongConfig.class);
            this.fillAttributeValues(node, atomicLongConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, atomicLongConfigBuilder);
                    continue;
                }
                if (!"quorum-ref".equals(nodeName)) continue;
                atomicLongConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.atomicLongManagedMap.put((Object)this.getAttribute(node, "name"), (Object)atomicLongConfigBuilder.getBeanDefinition());
        }

        public void handleAtomicReference(Node node) {
            BeanDefinitionBuilder atomicReferenceConfigBuilder = this.createBeanBuilder(AtomicReferenceConfig.class);
            this.fillAttributeValues(node, atomicReferenceConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, atomicReferenceConfigBuilder);
                    continue;
                }
                if (!"quorum-ref".equals(nodeName)) continue;
                atomicReferenceConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.atomicReferenceManagedMap.put((Object)this.getAttribute(node, "name"), (Object)atomicReferenceConfigBuilder.getBeanDefinition());
        }

        public void handleCountDownLatch(Node node) {
            BeanDefinitionBuilder countDownLatchConfigBuilder = this.createBeanBuilder(CountDownLatchConfig.class);
            this.fillAttributeValues(node, countDownLatchConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if (!"quorum-ref".equals(nodeName)) continue;
                countDownLatchConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.countDownLatchManagedMap.put((Object)this.getAttribute(node, "name"), (Object)countDownLatchConfigBuilder.getBeanDefinition());
        }

        public void handleQueue(Node node) {
            BeanDefinitionBuilder queueConfigBuilder = this.createBeanBuilder(QueueConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, queueConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    queueConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("queue-store".equals(nodeName)) {
                    this.handleQueueStoreConfig(childNode, queueConfigBuilder);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    queueConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, queueConfigBuilder);
            }
            this.queueManagedMap.put((Object)name, (Object)queueConfigBuilder.getBeanDefinition());
        }

        public void handleQueueStoreConfig(Node node, BeanDefinitionBuilder queueConfigBuilder) {
            BeanDefinitionBuilder queueStoreConfigBuilder = this.createBeanBuilder(QueueStoreConfig.class);
            AbstractBeanDefinition beanDefinition = queueStoreConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, queueStoreConfigBuilder);
                break;
            }
            String storeImplAttrName = "store-implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, queueStoreConfigBuilder, storeImplAttrName, factoryImplAttrName);
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem(storeImplAttrName);
            Node factoryImplRef = attributes.getNamedItem(factoryImplAttrName);
            if (factoryImplRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(storeImplAttrName), this.getTextContent(implRef));
            }
            queueConfigBuilder.addPropertyValue("queueStoreConfig", (Object)beanDefinition);
        }

        private void extractBasicStoreConfig(Node node, BeanDefinitionBuilder builder) {
            String storeImplAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, builder, storeImplAttrName, factoryImplAttrName);
            String implRef = this.getAttribute(node, storeImplAttrName);
            String factoryImplRef = this.getAttribute(node, factoryImplAttrName);
            if (factoryImplRef != null) {
                builder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), factoryImplRef);
            }
            if (implRef != null) {
                builder.addPropertyReference(this.xmlToJavaName("store-implementation"), implRef);
            }
        }

        public void handleList(Node node) {
            BeanDefinitionBuilder listConfigBuilder = this.createBeanBuilder(ListConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, listConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    listConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    listConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, listConfigBuilder);
            }
            this.listManagedMap.put((Object)name, (Object)listConfigBuilder.getBeanDefinition());
        }

        public void handleSet(Node node) {
            BeanDefinitionBuilder setConfigBuilder = this.createBeanBuilder(SetConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, setConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    setConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    setConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, setConfigBuilder);
            }
            this.setManagedMap.put((Object)name, (Object)setConfigBuilder.getBeanDefinition());
        }

        public void handleMap(Node node) {
            Node cacheDeserializedValueNode;
            Node maxSizePolicyNode;
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class);
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillAttributeValues(node, mapConfigBuilder, "maxSize", "maxSizePolicy");
            BeanDefinitionBuilder maxSizeConfigBuilder = this.createBeanBuilder(MaxSizeConfig.class);
            AbstractBeanDefinition maxSizeConfigBeanDefinition = maxSizeConfigBuilder.getBeanDefinition();
            mapConfigBuilder.addPropertyValue("maxSizeConfig", (Object)maxSizeConfigBeanDefinition);
            Node maxSizeNode = node.getAttributes().getNamedItem("max-size");
            if (maxSizeNode != null) {
                maxSizeConfigBuilder.addPropertyValue("size", (Object)this.getTextContent(maxSizeNode));
            }
            if ((maxSizePolicyNode = node.getAttributes().getNamedItem("max-size-policy")) != null) {
                maxSizeConfigBuilder.addPropertyValue(this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)maxSizePolicyNode)), (Object)MaxSizeConfig.MaxSizePolicy.valueOf((String)this.getTextContent(maxSizePolicyNode)));
            }
            if ((cacheDeserializedValueNode = node.getAttributes().getNamedItem("cache-deserialized-values")) != null) {
                mapConfigBuilder.addPropertyValue("cacheDeserializedValues", (Object)this.getTextContent(cacheDeserializedValueNode));
            }
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                ManagedList listeners;
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("map-store".equals(nodeName)) {
                    this.handleMapStoreConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCacheConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("wan-replication-ref".equals(nodeName)) {
                    this.handleWanReplicationRef(mapConfigBuilder, childNode);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : DomConfigHelper.childElements((Node)childNode)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapIndexConfigs", (Object)indexes);
                    continue;
                }
                if ("attributes".equals(nodeName)) {
                    ManagedList attributes = new ManagedList();
                    for (Node attributeNode : DomConfigHelper.childElements((Node)childNode)) {
                        BeanDefinitionBuilder attributeConfBuilder = this.createBeanBuilder(MapAttributeConfig.class);
                        this.fillAttributeValues(attributeNode, attributeConfBuilder, new String[0]);
                        attributes.add((Object)attributeConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapAttributeConfigs", (Object)attributes);
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    mapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    mapConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("query-caches".equals(nodeName)) {
                    ManagedList queryCaches = this.getQueryCaches(childNode);
                    mapConfigBuilder.addPropertyValue("queryCacheConfigs", (Object)queryCaches);
                    continue;
                }
                if ("partition-lost-listeners".endsWith(nodeName)) {
                    listeners = this.parseListeners(childNode, MapPartitionLostListenerConfig.class);
                    mapConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("hot-restart".equals(nodeName)) {
                    this.handleHotRestartConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if ("map-eviction-policy".equals(nodeName)) {
                    this.handleMapEvictionPolicyConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if (!"partition-strategy".equals(nodeName)) continue;
                PartitioningStrategyConfig psConfig = new PartitioningStrategyConfig(this.getTextContent(childNode));
                mapConfigBuilder.addPropertyValue("partitioningStrategyConfig", (Object)psConfig);
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private void handleMapEvictionPolicyConfig(BeanDefinitionBuilder mapConfigBuilder, Node childNode) {
            String className;
            NamedNodeMap attributes = childNode.getAttributes();
            Node implementationNode = attributes.getNamedItem("implementation");
            Node classNameNode = attributes.getNamedItem("class-name");
            String implementation = implementationNode != null ? this.getTextContent(implementationNode) : null;
            String string = className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            if (implementation != null) {
                mapConfigBuilder.addPropertyReference("mapEvictionPolicy", implementation);
            } else if (className != null) {
                className = Preconditions.checkHasText((String)className, (String)"map-eviction-policy `className` cannot be null or empty");
                try {
                    MapEvictionPolicy mapEvictionPolicy = (MapEvictionPolicy)ClassLoaderUtil.newInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)className);
                    mapConfigBuilder.addPropertyValue("mapEvictionPolicy", (Object)mapEvictionPolicy);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow((Throwable)e);
                }
            } else {
                throw new IllegalArgumentException("One of `className` or `implementation` attributes is required to create map-eviction-policy");
            }
        }

        private void handleHotRestartConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder hotRestartConfigBuilder = this.createBeanBuilder(HotRestartConfig.class);
            this.fillAttributeValues(node, hotRestartConfigBuilder, new String[0]);
            configBuilder.addPropertyValue("hotRestartConfig", (Object)hotRestartConfigBuilder.getBeanDefinition());
        }

        private ManagedList getQueryCaches(Node childNode) {
            ManagedList queryCaches = new ManagedList();
            for (Node queryCacheNode : DomConfigHelper.childElements((Node)childNode)) {
                BeanDefinitionBuilder beanDefinitionBuilder = this.parseQueryCaches(queryCacheNode);
                queryCaches.add((Object)beanDefinitionBuilder.getBeanDefinition());
            }
            return queryCaches;
        }

        private BeanDefinitionBuilder parseQueryCaches(Node queryCacheNode) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(QueryCacheConfig.class);
            for (Node node : DomConfigHelper.childElements((Node)queryCacheNode)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                String textContent = this.getTextContent(node);
                NamedNodeMap attributes = queryCacheNode.getAttributes();
                String cacheName = this.getTextContent(attributes.getNamedItem("name"));
                builder.addPropertyValue("name", (Object)cacheName);
                if ("predicate".equals(nodeName)) {
                    BeanDefinitionBuilder predicateBuilder = this.createBeanBuilder(PredicateConfig.class);
                    String predicateType = this.getTextContent(node.getAttributes().getNamedItem("type"));
                    if ("sql".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("sql", (Object)textContent);
                    } else if ("class-name".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("className", (Object)textContent);
                    }
                    builder.addPropertyValue("predicateConfig", (Object)predicateBuilder.getBeanDefinition());
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = new ManagedList();
                    String implementationAttr = "implementation";
                    for (Node listenerNode : DomConfigHelper.childElements((Node)node)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(EntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                        Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                        if (implementationNode != null) {
                            listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                        }
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    builder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("include-value".equals(nodeName)) {
                    boolean includeValue = DomConfigHelper.getBooleanValue((String)textContent);
                    builder.addPropertyValue("includeValue", (Object)includeValue);
                    continue;
                }
                if ("batch-size".equals(nodeName)) {
                    int batchSize = DomConfigHelper.getIntegerValue((String)"batch-size", (String)textContent.trim());
                    builder.addPropertyValue("batchSize", (Object)batchSize);
                    continue;
                }
                if ("buffer-size".equals(nodeName)) {
                    int bufferSize = DomConfigHelper.getIntegerValue((String)"buffer-size", (String)textContent.trim());
                    builder.addPropertyValue("bufferSize", (Object)bufferSize);
                    continue;
                }
                if ("delay-seconds".equals(nodeName)) {
                    int delaySeconds = DomConfigHelper.getIntegerValue((String)"delay-seconds", (String)textContent.trim());
                    builder.addPropertyValue("delaySeconds", (Object)delaySeconds);
                    continue;
                }
                if ("in-memory-format".equals(nodeName)) {
                    String value = textContent.trim();
                    builder.addPropertyValue("inMemoryFormat", (Object)InMemoryFormat.valueOf((String)StringUtil.upperCaseInternal((String)value)));
                    continue;
                }
                if ("coalesce".equals(nodeName)) {
                    boolean coalesce = DomConfigHelper.getBooleanValue((String)textContent);
                    builder.addPropertyValue("coalesce", (Object)coalesce);
                    continue;
                }
                if ("populate".equals(nodeName)) {
                    boolean populate = DomConfigHelper.getBooleanValue((String)textContent);
                    builder.addPropertyValue("populate", (Object)populate);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : DomConfigHelper.childElements((Node)node)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    builder.addPropertyValue("indexConfigs", (Object)indexes);
                    continue;
                }
                if (!"eviction".equals(nodeName)) continue;
                builder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
            }
            return builder;
        }

        public void handleCache(Node node) {
            BeanDefinitionBuilder cacheConfigBuilder = this.createBeanBuilder(CacheSimpleConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, cacheConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                ManagedList listeners;
                if ("eviction".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    cacheConfigBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(childNode));
                    continue;
                }
                if ("expiry-policy-factory".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    cacheConfigBuilder.addPropertyValue("expiryPolicyFactoryConfig", (Object)this.getExpiryPolicyFactoryConfig(childNode));
                    continue;
                }
                if ("cache-entry-listeners".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    listeners = new ManagedList();
                    for (Node listenerNode : DomConfigHelper.childElements((Node)childNode)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(CacheSimpleEntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, new String[0]);
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    cacheConfigBuilder.addPropertyValue("cacheEntryListeners", (Object)listeners);
                    continue;
                }
                if ("wan-replication-ref".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    this.handleWanReplicationRef(cacheConfigBuilder, childNode);
                    continue;
                }
                if ("partition-lost-listeners".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    listeners = this.parseListeners(childNode, CachePartitionLostListenerConfig.class);
                    cacheConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    cacheConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    cacheConfigBuilder.addPropertyValue("mergePolicy", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"hot-restart".equals(DomConfigHelper.cleanNodeName((Node)childNode))) continue;
                this.handleHotRestartConfig(cacheConfigBuilder, childNode);
            }
            this.cacheConfigManagedMap.put((Object)name, (Object)cacheConfigBuilder.getBeanDefinition());
        }

        public void handleWanReplication(Node node) {
            BeanDefinitionBuilder replicationConfigBuilder = this.createBeanBuilder(WanReplicationConfig.class);
            String name = this.getAttribute(node, "name");
            replicationConfigBuilder.addPropertyValue("name", (Object)name);
            ManagedList wanPublishers = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String nName = DomConfigHelper.cleanNodeName((Node)n);
                if ("wan-publisher".equals(nName)) {
                    wanPublishers.add((Object)this.handleWanPublisher(n));
                    continue;
                }
                if (!"wan-consumer".equals(nName)) continue;
                replicationConfigBuilder.addPropertyValue("wanConsumerConfig", (Object)this.handleWanConsumer(n));
            }
            replicationConfigBuilder.addPropertyValue("wanPublisherConfigs", (Object)wanPublishers);
            this.wanReplicationManagedMap.put((Object)name, (Object)replicationConfigBuilder.getBeanDefinition());
        }

        private AbstractBeanDefinition handleWanPublisher(Node n) {
            BeanDefinitionBuilder publisherBuilder = this.createBeanBuilder(WanPublisherConfig.class);
            AbstractBeanDefinition childBeanDefinition = publisherBuilder.getBeanDefinition();
            this.fillAttributeValues(n, publisherBuilder, Collections.emptyList());
            String className = this.getAttribute(n, "class-name");
            String implementation = this.getAttribute(n, "implementation");
            publisherBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                publisherBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create WanPublisherConfig!");
            for (Node child : DomConfigHelper.childElements((Node)n)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("properties".equals(nodeName)) {
                    this.handleProperties(child, publisherBuilder);
                    continue;
                }
                if ("queue-full-behavior".equals(nodeName) || "initial-publisher-state".equals(nodeName) || "queue-capacity".equals(nodeName) || "endpoint".equals(nodeName)) {
                    publisherBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    continue;
                }
                if (AliasedDiscoveryConfigUtils.supports((String)nodeName)) {
                    this.handleAliasedDiscoveryStrategy(child, publisherBuilder, nodeName);
                    continue;
                }
                if ("discovery-strategies".equals(nodeName)) {
                    this.handleDiscoveryStrategies(child, publisherBuilder);
                    continue;
                }
                if (!"wan-sync".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, WanSyncConfig.class, "wanSyncConfig", publisherBuilder, new String[0]);
            }
            return childBeanDefinition;
        }

        private AbstractBeanDefinition handleWanConsumer(Node n) {
            BeanDefinitionBuilder consumerConfigBuilder = this.createBeanBuilder(WanConsumerConfig.class);
            String className = this.getAttribute(n, "class-name");
            String implementation = this.getAttribute(n, "implementation");
            boolean persistWanReplicatedData = DomConfigHelper.getBooleanValue((String)this.getAttribute(n, "persist-wan-replicated-data"));
            consumerConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                consumerConfigBuilder.addPropertyReference("implementation", implementation);
            }
            consumerConfigBuilder.addPropertyValue("persistWanReplicatedData", (Object)persistWanReplicatedData);
            for (Node child : DomConfigHelper.childElements((Node)n)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, consumerConfigBuilder);
            }
            return consumerConfigBuilder.getBeanDefinition();
        }

        private void handlePartitionGroup(Node node) {
            BeanDefinitionBuilder partitionConfigBuilder = this.createBeanBuilder(PartitionGroupConfig.class);
            this.fillAttributeValues(node, partitionConfigBuilder, new String[0]);
            ManagedList memberGroups = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"member-group".equals(name)) continue;
                BeanDefinitionBuilder memberGroupBuilder = this.createBeanBuilder(MemberGroupConfig.class);
                ManagedList interfaces = new ManagedList();
                for (Node n : DomConfigHelper.childElements((Node)child)) {
                    if (!"interface".equals(DomConfigHelper.cleanNodeName((Node)n))) continue;
                    interfaces.add((Object)this.getTextContent(n));
                }
                memberGroupBuilder.addPropertyValue("interfaces", (Object)interfaces);
                memberGroups.add((Object)memberGroupBuilder.getBeanDefinition());
            }
            partitionConfigBuilder.addPropertyValue("memberGroupConfigs", (Object)memberGroups);
            this.configBuilder.addPropertyValue("partitionGroupConfig", (Object)partitionConfigBuilder.getBeanDefinition());
        }

        private void handleManagementCenter(Node node) {
            BeanDefinitionBuilder managementCenterConfigBuilder = this.createBeanBuilder(ManagementCenterConfig.class);
            this.fillAttributeValues(node, managementCenterConfigBuilder, new String[0]);
            boolean isComplexType = false;
            List<String> complexTypeElements = Arrays.asList("url", "mutual-auth");
            for (Node c : DomConfigHelper.childElements((Node)node)) {
                if (!complexTypeElements.contains(DomConfigHelper.cleanNodeName((Node)c))) continue;
                isComplexType = true;
                break;
            }
            if (isComplexType) {
                for (Node child : DomConfigHelper.childElements((Node)node)) {
                    if ("url".equals(DomConfigHelper.cleanNodeName((Node)child))) {
                        String url = this.getTextContent(child);
                        managementCenterConfigBuilder.addPropertyValue("url", (Object)url);
                        continue;
                    }
                    if (!"mutual-auth".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                    managementCenterConfigBuilder.addPropertyValue("mutualAuthConfig", (Object)this.handleMcMutualAuthConfig(child).getBeanDefinition());
                }
            }
            this.configBuilder.addPropertyValue("managementCenterConfig", (Object)managementCenterConfigBuilder.getBeanDefinition());
        }

        private BeanDefinitionBuilder handleMcMutualAuthConfig(Node node) {
            BeanDefinitionBuilder mcMutualAuthConfigBuilder = this.createBeanBuilder(MCMutualAuthConfig.class);
            this.fillAttributeValues(node, mcMutualAuthConfigBuilder, new String[0]);
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)n);
                if ("factory-class-name".equals(nodeName)) {
                    mcMutualAuthConfigBuilder.addPropertyValue("factoryClassName", (Object)this.getTextContent(n).trim());
                    continue;
                }
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(n, mcMutualAuthConfigBuilder);
            }
            return mcMutualAuthConfigBuilder;
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder configBuilder) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            this.fillAttributeValues(node, nearCacheConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if (!"eviction".equals(nodeName)) continue;
                this.handleEvictionConfig(childNode, nearCacheConfigBuilder);
            }
            configBuilder.addPropertyValue("nearCacheConfig", (Object)nearCacheConfigBuilder.getBeanDefinition());
        }

        private void handleEvictionConfig(Node node, BeanDefinitionBuilder configBuilder) {
            configBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
        }

        private CacheSimpleConfig.ExpiryPolicyFactoryConfig getExpiryPolicyFactoryConfig(Node node) {
            String className = this.getAttribute(node, "class-name");
            if (!StringUtil.isNullOrEmpty((String)className)) {
                return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(className);
            }
            CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = null;
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)n);
                if (!"timed-expiry-policy-factory".equals(nodeName)) continue;
                String expiryPolicyTypeStr = this.getAttribute(n, "expiry-policy-type");
                String durationAmountStr = this.getAttribute(n, "duration-amount");
                String timeUnitStr = this.getAttribute(n, "time-unit");
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.valueOf((String)StringUtil.upperCaseInternal((String)expiryPolicyTypeStr));
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL && (StringUtil.isNullOrEmpty((String)durationAmountStr) || StringUtil.isNullOrEmpty((String)timeUnitStr))) {
                    throw new InvalidConfigurationException("Both of the \"duration-amount\" or \"time-unit\" attributes are required for expiry policy factory configuration (except \"ETERNAL\" expiry policy type)");
                }
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = null;
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL) {
                    long durationAmount = Long.parseLong(durationAmountStr);
                    TimeUnit timeUnit = TimeUnit.valueOf(StringUtil.upperCaseInternal((String)timeUnitStr));
                    durationConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig(durationAmount, timeUnit);
                }
                timedExpiryPolicyFactoryConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig(expiryPolicyType, durationConfig);
            }
            if (timedExpiryPolicyFactoryConfig == null) {
                throw new InvalidConfigurationException("One of the \"class-name\" or \"timed-expire-policy-factory\" configuration is needed for expiry policy factory configuration");
            }
            return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(timedExpiryPolicyFactoryConfig);
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class);
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, mapStoreConfigBuilder);
                break;
            }
            String implAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            String initialModeAttrName = "initial-mode";
            this.fillAttributeValues(node, mapStoreConfigBuilder, implAttrName, factoryImplAttrName, "initialMode");
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem(implAttrName);
            Node factoryImplRef = attributes.getNamedItem(factoryImplAttrName);
            Node initialMode = attributes.getNamedItem(initialModeAttrName);
            if (factoryImplRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttrName), this.getTextContent(implRef));
            }
            if (initialMode != null) {
                MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf((String)StringUtil.upperCaseInternal((String)this.getTextContent(initialMode)));
                mapStoreConfigBuilder.addPropertyValue("initialLoadMode", (Object)mode);
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
        }

        public void handleMultiMap(Node node) {
            BeanDefinitionBuilder multiMapConfigBuilder = this.createBeanBuilder(MultiMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, multiMapConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    multiMapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    multiMapConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, multiMapConfigBuilder);
            }
            this.multiMapManagedMap.put((Object)name, (Object)multiMapConfigBuilder.getBeanDefinition());
        }

        public void handleTopic(Node node) {
            BeanDefinitionBuilder topicConfigBuilder = this.createBeanBuilder(TopicConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, topicConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                if ("message-listeners".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    ManagedList listeners = this.parseListeners(childNode, ListenerConfig.class);
                    topicConfigBuilder.addPropertyValue("messageListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("statistics-enabled".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    String statisticsEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("statisticsEnabled", (Object)statisticsEnabled);
                    continue;
                }
                if ("global-ordering-enabled".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    String globalOrderingEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("globalOrderingEnabled", (Object)globalOrderingEnabled);
                    continue;
                }
                if (!"multi-threading-enabled".equals(DomConfigHelper.cleanNodeName((Node)childNode))) continue;
                String multiThreadingEnabled = this.getTextContent(childNode);
                topicConfigBuilder.addPropertyValue("multiThreadingEnabled", (Object)multiThreadingEnabled);
            }
            this.topicManagedMap.put((Object)name, (Object)topicConfigBuilder.getBeanDefinition());
        }

        public void handleJobTracker(Node node) {
            BeanDefinitionBuilder jobTrackerConfigBuilder = this.createBeanBuilder(JobTrackerConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, jobTrackerConfigBuilder, new String[0]);
            this.jobTrackerManagedMap.put((Object)name, (Object)jobTrackerConfigBuilder.getBeanDefinition());
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(SecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("member-credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, securityConfigBuilder);
                    continue;
                }
                if ("member-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, true);
                    continue;
                }
                if ("client-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, false);
                    continue;
                }
                if ("client-permission-policy".equals(nodeName)) {
                    this.handlePermissionPolicy(child, securityConfigBuilder);
                    continue;
                }
                if ("client-permissions".equals(nodeName)) {
                    this.handleSecurityPermissions(child, securityConfigBuilder);
                    continue;
                }
                if ("security-interceptors".equals(nodeName)) {
                    this.handleSecurityInterceptors(child, securityConfigBuilder);
                    continue;
                }
                if (!"client-block-unmapped-actions".equals(nodeName)) continue;
                securityConfigBuilder.addPropertyValue("clientBlockUnmappedActions", (Object)DomConfigHelper.getBooleanValue((String)this.getTextContent(child)));
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        private void handleMemberAttributes(Node node) {
            BeanDefinitionBuilder memberAttributeConfigBuilder = this.createBeanBuilder(MemberAttributeConfig.class);
            AbstractBeanDefinition beanDefinition = memberAttributeConfigBuilder.getBeanDefinition();
            ManagedMap attributes = new ManagedMap();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"attribute".equals(name)) continue;
                String attributeName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String attributeType = this.getTextContent(n.getAttributes().getNamedItem("type")).trim();
                String value = this.getTextContent(n);
                Object oValue = "string".equals(attributeType) ? value : ("boolean".equals(attributeType) ? Boolean.valueOf(Boolean.parseBoolean(value)) : ("byte".equals(attributeType) ? Byte.valueOf(Byte.parseByte(value)) : ("double".equals(attributeType) ? Double.valueOf(Double.parseDouble(value)) : ("float".equals(attributeType) ? Float.valueOf(Float.parseFloat(value)) : ("int".equals(attributeType) ? Integer.valueOf(Integer.parseInt(value)) : ("long".equals(attributeType) ? Long.valueOf(Long.parseLong(value)) : ("short".equals(attributeType) ? Short.valueOf(Short.parseShort(value)) : value)))))));
                attributes.put((Object)attributeName, oValue);
            }
            memberAttributeConfigBuilder.addPropertyValue("attributes", (Object)attributes);
            this.configBuilder.addPropertyValue("memberAttributeConfig", (Object)beanDefinition);
        }

        private void handleNativeMemory(Node node) {
            BeanDefinitionBuilder nativeMemoryConfigBuilder = this.createBeanBuilder(NativeMemoryConfig.class);
            AbstractBeanDefinition beanDefinition = nativeMemoryConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, nativeMemoryConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"size".equals(nodeName)) continue;
                this.handleMemorySizeConfig(child, nativeMemoryConfigBuilder);
            }
            this.configBuilder.addPropertyValue("nativeMemoryConfig", (Object)beanDefinition);
        }

        private void handleMemorySizeConfig(Node node, BeanDefinitionBuilder nativeMemoryConfigBuilder) {
            BeanDefinitionBuilder memorySizeConfigBuilder = this.createBeanBuilder(MemorySize.class);
            NamedNodeMap attributes = node.getAttributes();
            Node value = attributes.getNamedItem("value");
            Node unit = attributes.getNamedItem("unit");
            memorySizeConfigBuilder.addConstructorArgValue((Object)this.getTextContent(value));
            memorySizeConfigBuilder.addConstructorArgValue((Object)MemoryUnit.valueOf((String)this.getTextContent(unit)));
            nativeMemoryConfigBuilder.addPropertyValue("size", (Object)memorySizeConfigBuilder.getBeanDefinition());
        }

        private void handleSecurityInterceptors(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedList lms = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"interceptor".equals(nodeName)) continue;
                BeanDefinitionBuilder siConfigBuilder = this.createBeanBuilder(SecurityInterceptorConfig.class);
                AbstractBeanDefinition beanDefinition = siConfigBuilder.getBeanDefinition();
                NamedNodeMap attributes = child.getAttributes();
                Node classNameNode = attributes.getNamedItem("class-name");
                String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
                Node implNode = attributes.getNamedItem("implementation");
                String implementation = implNode != null ? this.getTextContent(implNode) : null;
                Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create SecurityInterceptorConfig!");
                siConfigBuilder.addPropertyValue("className", (Object)className);
                if (implementation != null) {
                    siConfigBuilder.addPropertyReference("implementation", implementation);
                }
                lms.add(beanDefinition);
            }
            securityConfigBuilder.addPropertyValue("securityInterceptorConfigs", (Object)lms);
        }

        private void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("memberCredentialsConfig", (Object)beanDefinition);
        }

        private void handleLoginModules(Node node, BeanDefinitionBuilder securityConfigBuilder, boolean member) {
            ManagedList lms = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"login-module".equals(nodeName)) continue;
                this.handleLoginModule(child, (List<BeanDefinition>)lms);
            }
            if (member) {
                securityConfigBuilder.addPropertyValue("memberLoginModuleConfigs", (Object)lms);
            } else {
                securityConfigBuilder.addPropertyValue("clientLoginModuleConfigs", (Object)lms);
            }
        }

        private void handleLoginModule(Node node, List<BeanDefinition> list) {
            BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(LoginModuleConfig.class);
            AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, lmConfigBuilder, "class-name", "implementation");
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            lmConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                lmConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create LoginModule!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, lmConfigBuilder);
                break;
            }
            list.add((BeanDefinition)beanDefinition);
        }

        private void handlePermissionPolicy(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder permPolicyConfigBuilder = this.createBeanBuilder(PermissionPolicyConfig.class);
            AbstractBeanDefinition beanDefinition = permPolicyConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            permPolicyConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                permPolicyConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create PermissionPolicy!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, permPolicyConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("clientPolicyConfig", (Object)beanDefinition);
        }

        private void handleSecurityPermissions(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedSet permissions = new ManagedSet();
            NamedNodeMap attributes = node.getAttributes();
            Node onJoinOpAttribute = attributes.getNamedItem("on-join-operation");
            if (onJoinOpAttribute != null) {
                String onJoinOp = this.getTextContent(onJoinOpAttribute);
                OnJoinPermissionOperationName onJoinPermissionOperation = OnJoinPermissionOperationName.valueOf((String)StringUtil.upperCaseInternal((String)onJoinOp));
                securityConfigBuilder.addPropertyValue("onJoinPermissionOperation", (Object)onJoinPermissionOperation);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                PermissionConfig.PermissionType type = PermissionConfig.PermissionType.getType((String)nodeName);
                if (type == null) continue;
                this.handleSecurityPermission(child, (Set<BeanDefinition>)permissions, type);
            }
            securityConfigBuilder.addPropertyValue("clientPermissionConfigs", (Object)permissions);
        }

        private void handleSecurityPermission(Node node, Set<BeanDefinition> permissions, PermissionConfig.PermissionType type) {
            BeanDefinitionBuilder permissionConfigBuilder = this.createBeanBuilder(PermissionConfig.class);
            AbstractBeanDefinition beanDefinition = permissionConfigBuilder.getBeanDefinition();
            permissionConfigBuilder.addPropertyValue("type", (Object)type);
            NamedNodeMap attributes = node.getAttributes();
            Node nameNode = attributes.getNamedItem("name");
            String name = nameNode != null ? this.getTextContent(nameNode) : "*";
            permissionConfigBuilder.addPropertyValue("name", (Object)name);
            Node principalNode = attributes.getNamedItem("principal");
            String principal = principalNode != null ? this.getTextContent(principalNode) : "*";
            permissionConfigBuilder.addPropertyValue("principal", (Object)principal);
            ManagedList endpoints = new ManagedList();
            ManagedList actions = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("endpoints".equals(nodeName)) {
                    this.handleSecurityPermissionEndpoints(child, (List<String>)endpoints);
                    continue;
                }
                if (!"actions".equals(nodeName)) continue;
                this.handleSecurityPermissionActions(child, (List<String>)actions);
            }
            permissionConfigBuilder.addPropertyValue("endpoints", (Object)endpoints);
            permissionConfigBuilder.addPropertyValue("actions", (Object)actions);
            permissions.add((BeanDefinition)beanDefinition);
        }

        private void handleSecurityPermissionEndpoints(Node node, List<String> endpoints) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"endpoint".equals(nodeName)) continue;
                endpoints.add(this.getTextContent(child));
            }
        }

        private void handleSecurityPermissionActions(Node node, List<String> actions) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"action".equals(nodeName)) continue;
                actions.add(this.getTextContent(child));
            }
        }

        private void handleWanReplicationRef(BeanDefinitionBuilder beanDefinitionBuilder, Node childNode) {
            BeanDefinitionBuilder wanReplicationRefBuilder = this.createBeanBuilder(WanReplicationRef.class);
            AbstractBeanDefinition wanReplicationRefBeanDefinition = wanReplicationRefBuilder.getBeanDefinition();
            this.fillValues(childNode, wanReplicationRefBuilder, new String[0]);
            for (Node node : DomConfigHelper.childElements((Node)childNode)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                if (!nodeName.equals("filters")) continue;
                ManagedList filters = new ManagedList();
                this.handleFilters(node, (List<String>)filters);
                wanReplicationRefBuilder.addPropertyValue("filters", (Object)filters);
            }
            beanDefinitionBuilder.addPropertyValue("wanReplicationRef", (Object)wanReplicationRefBeanDefinition);
        }

        private void handleFilters(Node node, List<String> filters) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"filter-impl".equals(nodeName)) continue;
                filters.add(this.getTextContent(child));
            }
        }

        private void handleRestApi(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder restApiConfigBuilder = this.createBeanBuilder(RestApiConfig.class);
            AbstractBeanDefinition beanDefinition = restApiConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, restApiConfigBuilder, new String[0]);
            ManagedSet groupSet = new ManagedSet();
            for (RestEndpointGroup group : RestEndpointGroup.values()) {
                if (!group.isEnabledByDefault()) continue;
                groupSet.add((Object)group);
            }
            this.handleRestEndpointGroup(node, restApiConfigBuilder, (ManagedSet<RestEndpointGroup>)groupSet);
            networkConfigBuilder.addPropertyValue("restApiConfig", (Object)beanDefinition);
        }

        private void handleRestEndpointGroup(Node node, BeanDefinitionBuilder builder, ManagedSet<RestEndpointGroup> groupSet) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"endpoint-group".equals(nodeName)) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node attrEnabled = attributes.getNamedItem("enabled");
                boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue((String)this.getTextContent(attrEnabled));
                String name = this.getTextContent(attributes.getNamedItem("name"));
                RestEndpointGroup group = null;
                try {
                    group = RestEndpointGroup.valueOf((String)name);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigurationException("Wrong name attribute value was provided in endpoint-group element: " + name + "\nAllowed values: " + Arrays.toString(RestEndpointGroup.values()));
                }
                if (enabled) {
                    groupSet.add((Object)group);
                    continue;
                }
                groupSet.remove((Object)group);
            }
            builder.addPropertyValue("enabledGroups", groupSet);
        }

        private void handleMemcacheProtocol(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder memcacheProtocolConfigBuilder = this.createBeanBuilder(MemcacheProtocolConfig.class);
            AbstractBeanDefinition beanDefinition = memcacheProtocolConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, memcacheProtocolConfigBuilder, new String[0]);
            networkConfigBuilder.addPropertyValue("memcacheProtocolConfig", (Object)beanDefinition);
        }

        private EndpointQualifier createEndpointQualifier(ProtocolType type, Node node) {
            return EndpointQualifier.resolve((ProtocolType)type, (String)this.getAttribute(node, "name"));
        }
    }
}

