/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spring;

import com.atlassian.nutcluster.config.DomConfigHelper;
import com.atlassian.nutcluster.instance.NutclusterInstanceFactory;
import com.atlassian.nutcluster.spring.AbstractNutclusterBeanDefinitionParser;
import com.atlassian.nutcluster.spring.NutclusterConfigBeanDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NutclusterInstanceDefinitionParser
extends AbstractNutclusterBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(this, parserContext);
        springXmlBuilder.handle(element);
        return springXmlBuilder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractNutclusterBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;

        SpringXmlBuilder(NutclusterInstanceDefinitionParser nutclusterInstanceDefinitionParser, ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(NutclusterInstanceFactory.class);
            this.builder.setFactoryMethod("newNutclusterInstance");
            this.builder.setDestroyMethodName("shutdown");
        }

        AbstractBeanDefinition getBeanDefinition() {
            return this.builder.getBeanDefinition();
        }

        public void handle(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            Element config = null;
            for (Node node : DomConfigHelper.childElements((Node)element)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                if (!"config".equals(nodeName)) continue;
                config = (Element)node;
            }
            NutclusterConfigBeanDefinitionParser configParser = new NutclusterConfigBeanDefinitionParser();
            AbstractBeanDefinition configBeanDef = configParser.parseInternal(config, this.parserContext);
            this.builder.addConstructorArgValue((Object)configBeanDef);
        }
    }
}

