/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spring;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.spring.AbstractNutclusterBeanDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NutclusterTypeBeanDefinitionParser
extends AbstractNutclusterBeanDefinitionParser {
    private final String type;
    private final String methodName;

    public NutclusterTypeBeanDefinitionParser(String type) {
        this.type = type;
        this.methodName = "get" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        BeanDefinitionBuilder builder = springXmlBuilder.getBuilder();
        builder.setFactoryMethod(this.methodName);
        return builder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractNutclusterBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;

        SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(NutclusterInstance.class);
        }

        BeanDefinitionBuilder getBuilder() {
            return this.builder;
        }

        public void handle(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                Node instanceRefNode = attributes.getNamedItem("instance-ref");
                if (instanceRefNode == null) {
                    throw new IllegalStateException("'instance-ref' attribute is required for creating Nutcluster " + NutclusterTypeBeanDefinitionParser.this.type);
                }
                String instanceRef = this.getTextContent(instanceRefNode);
                this.builder.getRawBeanDefinition().setFactoryBeanName(instanceRef);
                this.builder.addDependsOn(instanceRef);
                Node nameNode = attributes.getNamedItem("name");
                if (nameNode == null) {
                    nameNode = attributes.getNamedItem("id");
                }
                this.builder.addConstructorArgValue((Object)this.getTextContent(nameNode));
            }
        }
    }
}

