/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spring.cache;

import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.spring.cache.NutclusterCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class NutclusterCacheManager
implements CacheManager {
    public static final String CACHE_PROP = "hazelcast.spring.cache.prop";
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private NutclusterInstance NutclusterInstance;
    private long defaultReadTimeout;
    private Map<String, Long> readTimeoutMap = new HashMap<String, Long>();

    public NutclusterCacheManager() {
    }

    public NutclusterCacheManager(NutclusterInstance NutclusterInstance2) {
        this.NutclusterInstance = NutclusterInstance2;
    }

    public Cache getCache(String name) {
        Cache cache = (Cache)this.caches.get(name);
        if (cache == null) {
            IMap map = this.NutclusterInstance.getMap(name);
            cache = new NutclusterCache((IMap<Object, Object>)map);
            long cacheTimeout = this.calculateCacheReadTimeout(name);
            ((NutclusterCache)cache).setReadTimeout(cacheTimeout);
            Cache currentCache = this.caches.putIfAbsent(name, cache);
            if (currentCache != null) {
                cache = currentCache;
            }
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        Collection distributedObjects = this.NutclusterInstance.getDistributedObjects();
        for (DistributedObject distributedObject : distributedObjects) {
            if (!(distributedObject instanceof IMap)) continue;
            IMap map = (IMap)distributedObject;
            cacheNames.add(map.getName());
        }
        return cacheNames;
    }

    private long calculateCacheReadTimeout(String name) {
        Long timeout = this.getReadTimeoutMap().get(name);
        return timeout == null ? this.defaultReadTimeout : timeout;
    }

    public NutclusterInstance getNutclusterInstance() {
        return this.NutclusterInstance;
    }

    public void setNutclusterInstance(NutclusterInstance NutclusterInstance2) {
        this.NutclusterInstance = NutclusterInstance2;
    }

    private void parseOptions(String options) {
        if (null == options || options.trim().isEmpty()) {
            return;
        }
        for (String option : options.split(",")) {
            this.parseOption(option);
        }
    }

    private void parseOption(String option) {
        String[] keyValue = option.split("=");
        Assert.isTrue((keyValue.length != 0 ? 1 : 0) != 0, (String)"blank key-value pair");
        Assert.isTrue((keyValue.length <= 2 ? 1 : 0) != 0, (String)String.format("key-value pair %s with more than one equals sign", option));
        String key = keyValue[0].trim();
        String value = keyValue.length == 1 ? null : keyValue[1].trim();
        Assert.isTrue((value != null && !value.isEmpty() ? 1 : 0) != 0, (String)String.format("value for %s should not be null or empty", key));
        if ("defaultReadTimeout".equals(key)) {
            this.defaultReadTimeout = Long.parseLong(value);
        } else {
            this.readTimeoutMap.put(key, Long.parseLong(value));
        }
    }

    public long getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    public void setDefaultReadTimeout(long defaultReadTimeout) {
        this.defaultReadTimeout = defaultReadTimeout;
    }

    public Map<String, Long> getReadTimeoutMap() {
        return this.readTimeoutMap;
    }

    @Autowired
    public void setCacheOptions(@Value(value="${hazelcast.spring.cache.prop:}") String options) {
        this.parseOptions(options);
    }
}

