/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spring.cache;

import com.atlassian.nutcluster.cache.impl.NutclusterServerCachingProvider;
import com.atlassian.nutcluster.client.cache.impl.NutclusterClientCachingProvider;
import com.atlassian.nutcluster.client.impl.clientside.NutclusterClientProxy;
import com.atlassian.nutcluster.core.Nutcluster;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.util.ExceptionUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.cache.CacheManager;

public final class SpringNutclusterCachingProvider {
    private SpringNutclusterCachingProvider() {
    }

    public static CacheManager getCacheManager(NutclusterInstance instance, String uriString, Properties props) {
        URI uri = null;
        if (uriString != null) {
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (instance instanceof NutclusterClientProxy) {
            return NutclusterClientCachingProvider.createCachingProvider((NutclusterInstance)instance).getCacheManager(uri, null, props);
        }
        return NutclusterServerCachingProvider.createCachingProvider((NutclusterInstance)instance).getCacheManager(uri, null, props);
    }

    public static CacheManager getCacheManager(String uriString, Properties properties) {
        String instanceName = properties.getProperty("nutcluster.instance.name");
        if (instanceName == null) {
            throw new IllegalStateException("Either instance-ref' attribute or nutcluster.instance.name property is required for creating cache manager");
        }
        return SpringNutclusterCachingProvider.getCacheManager(Nutcluster.getNutclusterInstanceByName((String)instanceName), uriString, properties);
    }
}

