/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spring.context;

import com.atlassian.nutcluster.core.ManagedContext;
import com.atlassian.nutcluster.executor.impl.RunnableAdapter;
import com.atlassian.nutcluster.spring.context.SpringAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringManagedContext
implements ManagedContext,
ApplicationContextAware {
    private AutowireCapableBeanFactory beanFactory;

    public Object initialize(Object obj) {
        Object resultObject = obj;
        if (obj != null) {
            if (obj instanceof RunnableAdapter) {
                RunnableAdapter adapter = (RunnableAdapter)obj;
                Object runnable = adapter.getRunnable();
                runnable = this.initializeIfSpringAwareIsPresent(runnable);
                adapter.setRunnable((Runnable)runnable);
            } else {
                resultObject = this.initializeIfSpringAwareIsPresent(obj);
            }
        }
        return resultObject;
    }

    private Object initializeIfSpringAwareIsPresent(Object obj) {
        Class<?> clazz = obj.getClass();
        SpringAware s = clazz.getAnnotation(SpringAware.class);
        Object resultObject = obj;
        if (s != null) {
            String name = s.beanName().trim();
            if (name.isEmpty()) {
                name = clazz.getName();
            }
            this.beanFactory.autowireBean(obj);
            resultObject = this.beanFactory.initializeBean(obj, name);
        }
        return resultObject;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext.getAutowireCapableBeanFactory();
    }
}

