/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spring.transaction;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.spring.transaction.TransactionContextHolder;
import com.atlassian.nutcluster.transaction.TransactionContext;
import com.atlassian.nutcluster.transaction.TransactionException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class NutclusterTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager {
    private NutclusterInstance NutclusterInstance;

    public NutclusterTransactionManager(NutclusterInstance NutclusterInstance2) {
        this.NutclusterInstance = NutclusterInstance2;
    }

    public static TransactionContext getTransactionContext(NutclusterInstance NutclusterInstance2) {
        TransactionContextHolder transactionContextHolder = (TransactionContextHolder)TransactionSynchronizationManager.getResource((Object)NutclusterInstance2);
        if (transactionContextHolder == null) {
            throw new NoTransactionException("No TransactionContext with actual transaction available for current thread");
        }
        return transactionContextHolder.getContext();
    }

    public TransactionContext getTransactionContext() {
        return NutclusterTransactionManager.getTransactionContext(this.NutclusterInstance);
    }

    public Object getResourceFactory() {
        return this.NutclusterInstance;
    }

    protected Object doGetTransaction() throws org.springframework.transaction.TransactionException {
        NutclusterTransactionObject txObject = new NutclusterTransactionObject();
        TransactionContextHolder transactionContextHolder = (TransactionContextHolder)TransactionSynchronizationManager.getResource((Object)this.NutclusterInstance);
        if (transactionContextHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound TransactionContext [" + String.valueOf(transactionContextHolder.getContext()) + "]"));
            }
            txObject.setTransactionContextHolder(transactionContextHolder, false);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) throws org.springframework.transaction.TransactionException {
        return ((NutclusterTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws org.springframework.transaction.TransactionException {
        NutclusterTransactionObject txObject = (NutclusterTransactionObject)transaction;
        try {
            if (txObject.getTransactionContextHolder() == null) {
                TransactionContext transactionContext = this.NutclusterInstance.newTransactionContext();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new TransactionContext [" + String.valueOf(transactionContext) + "]"));
                }
                txObject.setTransactionContextHolder(new TransactionContextHolder(transactionContext), true);
            }
            txObject.getTransactionContextHolder().beginTransaction();
            if (txObject.isNewTransactionContextHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.NutclusterInstance, (Object)txObject.getTransactionContextHolder());
            }
        }
        catch (Throwable ex) {
            this.closeTransactionContextAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not begin Nutcluster transaction", ex);
        }
    }

    private void closeTransactionContextAfterFailedBegin(NutclusterTransactionObject txObject) {
        if (txObject.isNewTransactionContextHolder()) {
            TransactionContext context = txObject.getTransactionContextHolder().getContext();
            try {
                context.rollbackTransaction();
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not rollback Nutcluster transaction after failed transaction begin", ex);
            }
            txObject.setTransactionContextHolder(null, false);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        NutclusterTransactionObject txObject = (NutclusterTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Nutcluster transaction on TransactionContext [" + String.valueOf(txObject.getTransactionContextHolder().getContext()) + "]"));
        }
        try {
            txObject.getTransactionContextHolder().getContext().commitTransaction();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Nutcluster transaction", (Throwable)ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        NutclusterTransactionObject txObject = (NutclusterTransactionObject)status.getTransaction();
        txObject.setRollbackOnly(true);
    }

    protected void doRollback(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        NutclusterTransactionObject txObject = (NutclusterTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Nutcluster transaction on TransactionContext [" + String.valueOf(txObject.getTransactionContextHolder().getContext()) + "]"));
        }
        TransactionContext tx = txObject.getTransactionContextHolder().getContext();
        tx.rollbackTransaction();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        NutclusterTransactionObject txObject = (NutclusterTransactionObject)transaction;
        if (txObject.isNewTransactionContextHolder()) {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.NutclusterInstance);
        }
        txObject.getTransactionContextHolder().clear();
    }

    private static class NutclusterTransactionObject
    implements SmartTransactionObject {
        private TransactionContextHolder transactionContextHolder;
        private boolean newTransactionContextHolder;
        private boolean rollbackOnly;

        private NutclusterTransactionObject() {
        }

        void setRollbackOnly(boolean rollbackOnly) {
            this.rollbackOnly = rollbackOnly;
        }

        void setTransactionContextHolder(TransactionContextHolder transactionContextHolder, boolean newTransactionContextHolder) {
            this.transactionContextHolder = transactionContextHolder;
            this.newTransactionContextHolder = newTransactionContextHolder;
        }

        TransactionContextHolder getTransactionContextHolder() {
            return this.transactionContextHolder;
        }

        boolean isNewTransactionContextHolder() {
            return this.newTransactionContextHolder;
        }

        boolean hasTransaction() {
            return this.transactionContextHolder != null && this.transactionContextHolder.isTransactionActive();
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        public void flush() {
        }
    }
}

