/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.comment.NoSuchCommentException;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.dmz.suggestion.ApplySuggestionRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.suggestion.SuggestionValidationException;
import com.atlassian.bitbucket.internal.suggestion.ValidSuggestion;
import com.atlassian.bitbucket.internal.suggestion.dao.SuggestionGroupDao;
import com.atlassian.bitbucket.internal.suggestion.model.InternalSuggestionGroup;
import com.atlassian.bitbucket.internal.suggestion.parser.CommonMarkSuggestionParser;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ApplySuggestionValidator {
    private final CommentDao commentDao;
    private final I18nService i18nService;
    private final CommonMarkSuggestionParser parser;
    private final PermissionService permissionService;
    private final SuggestionGroupDao suggestionGroupDao;

    public ApplySuggestionValidator(CommentDao commentDao, I18nService i18nService, CommonMarkSuggestionParser parser, PermissionService permissionService, SuggestionGroupDao suggestionGroupDao) {
        this.commentDao = commentDao;
        this.i18nService = i18nService;
        this.parser = parser;
        this.permissionService = permissionService;
        this.suggestionGroupDao = suggestionGroupDao;
    }

    @Nonnull
    public ValidSuggestion validate(@Nonnull ApplySuggestionRequest request) {
        long commentId = Objects.requireNonNull(request, "request").getCommentId();
        InternalSuggestionGroup suggestionGroup = this.validateSuggestionGroup(commentId);
        InternalComment comment = this.validateComment(commentId, request.getCommentVersion());
        CommentThread thread = comment.getThread();
        CommentThreadDiffAnchor anchor = this.validateAnchor(thread);
        this.validatePullRequest(request.getPullRequest(), request.getPullRequestVersion(), (Comment)comment);
        int suggestionIndex = request.getSuggestionIndex();
        String suggestion = this.validateSuggestion((Comment)comment, suggestionIndex);
        return new ValidSuggestion.Builder().anchor(anchor).comment((Comment)comment).suggestionGroup(suggestionGroup).suggestion(suggestion).suggestionIndex(suggestionIndex).build();
    }

    private CommentThreadDiffAnchor validateAnchor(CommentThread thread) {
        CommentThreadDiffAnchor anchor = (CommentThreadDiffAnchor)thread.getAnchor().orElseThrow(() -> this.validationException("bitbucket.pullrequest.suggestion.apply.invalidcommenttype", new Object[0]));
        if (!anchor.isLineAnchor()) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.invalidcommenttype", new Object[0]);
        }
        if (anchor.getDiffType() != CommentThreadDiffAnchorType.EFFECTIVE) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.invaliddifftype", new Object[0]);
        }
        if (anchor.isOrphaned()) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.invalidorphanedcomment", new Object[0]);
        }
        Optional startLineType = anchor.getMultilineStartLineType();
        if (startLineType.isPresent() && startLineType.get() == DiffSegmentType.REMOVED) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.invalidremovedline", new Object[0]);
        }
        Optional lineType = anchor.getLineType();
        if (lineType.isPresent() && lineType.get() == DiffSegmentType.REMOVED) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.invalidremovedline", new Object[0]);
        }
        return anchor;
    }

    private InternalComment validateComment(long commentId, int commentVersion) {
        InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.commentnotfound", String.valueOf(commentId));
        }
        if (comment.getVersion() != commentVersion) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.commentversionmismatch", new Object[0]);
        }
        return comment;
    }

    private void validatePullRequest(PullRequest pullRequest, int pullRequestVersion, Comment comment) {
        InternalPullRequest commentPullRequest = (InternalPullRequest)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<PullRequest>(){

            public PullRequest visit(@Nonnull CommitDiscussion discussion) {
                throw ApplySuggestionValidator.this.validationException("bitbucket.pullrequest.suggestion.apply.invalidcommitcomment", new Object[0]);
            }

            public PullRequest visit(@Nonnull PullRequest pullRequest) {
                return pullRequest;
            }
        });
        if (commentPullRequest.getGlobalId() != ((InternalPullRequest)pullRequest).getGlobalId()) {
            throw new NoSuchCommentException(this.i18nService.createKeyedMessage("bitbucket.pullrequest.suggestion.apply.commentnotfound", new Object[]{String.valueOf(comment.getId())}));
        }
        if (!pullRequest.isOpen()) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.invalidprstate", new Object[0]);
        }
        if (pullRequest.isLocked()) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.prlocked", new Object[0]);
        }
        if (pullRequest.getVersion() != pullRequestVersion) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.prversionmismatch", new Object[0]);
        }
        if (!this.permissionService.hasRepositoryPermission(pullRequest.getFromRef().getRepository(), Permission.REPO_WRITE)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.pullrequest.suggestion.apply.notpermitted", new Object[0]));
        }
    }

    private String validateSuggestion(Comment comment, int suggestionIndex) {
        List<String> suggestions = this.parser.parseSuggestions(comment.getText());
        if (suggestions.isEmpty()) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.commenthasnosuggestions", new Object[0]);
        }
        if (suggestionIndex >= suggestions.size()) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.suggestionindexnotfound", String.valueOf(suggestionIndex));
        }
        return suggestions.get(suggestionIndex);
    }

    private InternalSuggestionGroup validateSuggestionGroup(long commentId) {
        InternalSuggestionGroup suggestion = (InternalSuggestionGroup)this.suggestionGroupDao.getById(commentId);
        if (suggestion == null) {
            throw this.validationException("bitbucket.pullrequest.suggestion.apply.suggestionnotfound", String.valueOf(commentId));
        }
        Optional applyErrorMessageKey = suggestion.getState().getApplyErrorMessageKey();
        if (applyErrorMessageKey.isPresent()) {
            throw this.validationException((String)applyErrorMessageKey.get(), new Object[0]);
        }
        return suggestion;
    }

    private SuggestionValidationException validationException(String i18nKey, Object ... parameters) {
        return new SuggestionValidationException(this.i18nService.createKeyedMessage(i18nKey, parameters));
    }
}

