/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentPropertyContext;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.comment.FlatteningCommentPropertyProvider;
import com.atlassian.bitbucket.internal.suggestion.InternalSuggestionService;
import com.atlassian.bitbucket.internal.suggestion.PullRequestCommentableVisitor;
import com.atlassian.bitbucket.internal.suggestion.model.InternalSuggestionGroup;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CommentSuggestionPropertyProvider
extends FlatteningCommentPropertyProvider {
    private static final String SUGGESTION_INDEX = "suggestionIndex";
    private static final String SUGGESTION_STATE = "suggestionState";
    private final FeatureManager featureManager;
    private final InternalSuggestionService suggestionService;

    public CommentSuggestionPropertyProvider(FeatureManager featureManager, InternalSuggestionService suggestionService) {
        this.featureManager = featureManager;
        this.suggestionService = suggestionService;
    }

    protected void doProvideProperties(@Nonnull CommentPropertyContext context) {
        PullRequest pullRequest = (PullRequest)context.accept((CommentableVisitor)new PullRequestCommentableVisitor());
        if (pullRequest == null || !this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_SUGGESTIONS)) {
            return;
        }
        Map suggestionGroups = this.suggestionService.findByComments((Iterable<Comment>)context).stream().collect(Collectors.toMap(InternalSuggestionGroup::getCommentId, Function.identity()));
        for (Comment comment : context) {
            InternalSuggestionGroup suggestionGroup = (InternalSuggestionGroup)suggestionGroups.get(comment.getId());
            if (suggestionGroup == null) continue;
            context.setProperty(comment, SUGGESTION_STATE, (Object)suggestionGroup.getState());
            Integer appliedIndex = suggestionGroup.getAppliedIndex();
            if (appliedIndex == null) continue;
            context.setProperty(comment, SUGGESTION_INDEX, (Object)appliedIndex);
        }
    }
}

