/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.EditFileRequest;
import com.atlassian.bitbucket.dmz.pull.PullRequestCommitAuthor;
import com.atlassian.bitbucket.dmz.suggestion.ApplySuggestionRequest;
import com.atlassian.bitbucket.dmz.suggestion.SuggestionState;
import com.atlassian.bitbucket.dmz.throttle.DmzThrottleService;
import com.atlassian.bitbucket.dmz.throttle.Ticket;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.suggestion.ApplySuggestionValidator;
import com.atlassian.bitbucket.internal.suggestion.InternalSuggestionService;
import com.atlassian.bitbucket.internal.suggestion.LineReplacingOutputStream;
import com.atlassian.bitbucket.internal.suggestion.MultilineSuggestionValidator;
import com.atlassian.bitbucket.internal.suggestion.PullRequestCommentableVisitor;
import com.atlassian.bitbucket.internal.suggestion.SuggestionApplyException;
import com.atlassian.bitbucket.internal.suggestion.SuggestionDriftCalculator;
import com.atlassian.bitbucket.internal.suggestion.SuggestionDriftResult;
import com.atlassian.bitbucket.internal.suggestion.SuggestionValidationException;
import com.atlassian.bitbucket.internal.suggestion.ValidSuggestion;
import com.atlassian.bitbucket.internal.suggestion.analytics.SuggestionAddedEvent;
import com.atlassian.bitbucket.internal.suggestion.analytics.SuggestionApplyFailedEvent;
import com.atlassian.bitbucket.internal.suggestion.analytics.SuggestionApplySuccessfulEvent;
import com.atlassian.bitbucket.internal.suggestion.analytics.SuggestionFailureType;
import com.atlassian.bitbucket.internal.suggestion.dao.SuggestionGroupDao;
import com.atlassian.bitbucket.internal.suggestion.model.InternalSuggestionGroup;
import com.atlassian.bitbucket.internal.suggestion.parser.CommonMarkSuggestionParser;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.annotation.RewriteExceptions;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Transactional(readOnly=true)
@RewriteExceptions
public class DefaultSuggestionService
implements InternalSuggestionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSuggestionService.class);
    private final CommentUpdateProcessor commentUpdateProcessor;
    private final ContentService contentService;
    private final SuggestionGroupDao dao;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final MultilineSuggestionValidator multilineSuggestionValidator;
    private final CommonMarkSuggestionParser parser;
    private final StorageService storageService;
    private final PullRequestCommitAuthor suggestionAuthor;
    private final SuggestionDriftCalculator suggestionDriftCalculator;
    private final DmzThrottleService throttleService;
    private final ApplySuggestionValidator validator;
    private final TransactionTemplate withNewTransaction;

    public DefaultSuggestionService(CommentUpdateProcessor commentUpdateProcessor, ContentService contentService, SuggestionGroupDao dao, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, MultilineSuggestionValidator multilineSuggestionValidator, CommonMarkSuggestionParser parser, StorageService storageService, String suggestionAuthor, SuggestionDriftCalculator suggestionDriftCalculator, DmzThrottleService throttleService, PlatformTransactionManager transactionManager, ApplySuggestionValidator validator) {
        this.commentUpdateProcessor = commentUpdateProcessor;
        this.contentService = contentService;
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.multilineSuggestionValidator = multilineSuggestionValidator;
        this.parser = parser;
        this.storageService = storageService;
        this.suggestionAuthor = PullRequestCommitAuthor.fromName((String)suggestionAuthor).orElse(PullRequestCommitAuthor.AUTHOR);
        this.suggestionDriftCalculator = suggestionDriftCalculator;
        this.throttleService = throttleService;
        this.validator = validator;
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Secured(value={"Permission checks done by the ApplySuggestionValidator"})
    @Transactional
    public void apply(@Nonnull ApplySuggestionRequest request) {
        int suggestionIndex;
        ValidSuggestion validationResult;
        block16: {
            if (!this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_SUGGESTIONS)) {
                throw new PullRequestSuggestionsDisabledException(this.i18nService.createKeyedMessage("bitbucket.pullrequest.suggestion.disabled", new Object[0]));
            }
            this.commentUpdateProcessor.maybeProcess((InternalPullRequest)request.getPullRequest());
            try {
                validationResult = this.validator.validate(Objects.requireNonNull(request, "request"));
            }
            catch (SuggestionValidationException e) {
                this.eventPublisher.publish((Object)new SuggestionApplyFailedEvent(this, null, SuggestionFailureType.VALIDATION, null, request.getSuggestionIndex()));
                throw e;
            }
            CommentThreadDiffAnchor anchor = validationResult.getAnchor();
            PullRequestRef fromRef = request.getPullRequest().getFromRef();
            suggestionIndex = validationResult.getSuggestionIndex();
            Path updatedFile = null;
            try {
                try (Ticket ignored = this.throttleService.acquireTicket("scm-command");){
                    SuggestionDriftResult driftResult = anchor.isMultilineAnchor() ? this.multilineSuggestionValidator.calculateDriftResult(request.getPullRequest(), anchor) : this.suggestionDriftCalculator.calculateDriftResult(request.getPullRequest(), anchor);
                    Path finalUpdatedFile = updatedFile = Files.createTempFile(this.storageService.getTempDir(), "suggestion", ".tmp", new FileAttribute[0]);
                    this.contentService.streamFile(fromRef.getRepository(), fromRef.getId(), driftResult.getPath(), contentType -> new LineReplacingOutputStream(Files.newOutputStream(finalUpdatedFile, new OpenOption[0]), driftResult.getSuggestionRange(), validationResult.getSuggestion()));
                    EditFileRequest editFileRequest = new EditFileRequest.Builder(fromRef.getId(), driftResult.getPath(), fromRef.getRepository()).author(this.chooseCommitAuthor(request.getPullRequest(), validationResult.getComment())).content(() -> Files.newInputStream(finalUpdatedFile, new OpenOption[0])).message(request.getCommitMessage()).sourceCommitId(fromRef.getLatestCommit()).build();
                    this.contentService.editFile(editFileRequest);
                }
                if (updatedFile == null) break block16;
            }
            catch (RepositoryHookVetoedException e) {
                try {
                    this.eventPublisher.publish((Object)new SuggestionApplyFailedEvent(this, validationResult.getComment(), SuggestionFailureType.HOOK, request.getPullRequest(), suggestionIndex));
                    throw e;
                    catch (ServiceException | IOException e2) {
                        this.updateSuggestionStatusInNewTransaction(validationResult.getSuggestionGroup(), SuggestionState.APPLY_FAILED, suggestionIndex);
                        this.eventPublisher.publish((Object)new SuggestionApplyFailedEvent(this, validationResult.getComment(), SuggestionFailureType.APPLY, request.getPullRequest(), suggestionIndex));
                        throw new SuggestionApplyException(this.i18nService.createKeyedMessage("bitbucket.pullrequest.suggestion.apply.applyfailed", new Object[0]), e2);
                    }
                }
                catch (Throwable throwable) {
                    if (updatedFile != null) {
                        MoreFiles.deleteQuietly(updatedFile);
                    }
                    throw throwable;
                }
            }
            MoreFiles.deleteQuietly((Path)updatedFile);
        }
        this.updateSuggestionStatus(validationResult.getSuggestionGroup(), SuggestionState.APPLIED, suggestionIndex);
        this.eventPublisher.publish((Object)new SuggestionApplySuccessfulEvent(this, request.getPullRequest(), validationResult.getComment(), suggestionIndex));
    }

    @Override
    @Nonnull
    public Set<InternalSuggestionGroup> findByComments(@Nonnull Iterable<Comment> comments) {
        return this.dao.findByComments(Objects.requireNonNull(comments, "comments"));
    }

    @Override
    @Transactional
    @Unsecured(value="Internal interface method - comment create/edit is effectively the permission check for this method")
    public void updateCommentSuggestions(@Nonnull Comment comment) {
        List<String> suggestions = this.parser.parseSuggestions(comment.getText());
        boolean commentHasSuggestion = !suggestions.isEmpty();
        boolean suggestionInDb = this.dao.findByComment(comment).isPresent();
        if (commentHasSuggestion && !suggestionInDb) {
            this.dao.create(new InternalSuggestionGroup.Builder((InternalComment)comment).state(SuggestionState.UNAPPLIED).build());
            PullRequest pullRequest = (PullRequest)((InternalComment)comment).getThread().getCommentable().accept((CommentableVisitor)new PullRequestCommentableVisitor());
            this.eventPublisher.publish((Object)new SuggestionAddedEvent(this, pullRequest, suggestions.size(), comment));
        } else if (!commentHasSuggestion && suggestionInDb) {
            this.dao.deleteByComment(comment);
        }
    }

    @Nullable
    private ApplicationUser chooseCommitAuthor(PullRequest pullRequest, Comment comment) {
        if (this.suggestionAuthor == PullRequestCommitAuthor.ACTOR) {
            return null;
        }
        ApplicationUser commentAuthor = comment.getAuthor();
        if (StringUtils.isBlank((CharSequence)commentAuthor.getEmailAddress())) {
            log.info("{}:{} comment {} - {} does not have an e-mail address; falling back on the current user as author of the suggestion.", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), comment.getId(), commentAuthor.getName()});
            return null;
        }
        return commentAuthor;
    }

    private void updateSuggestionStatus(InternalSuggestionGroup suggestionGroup, SuggestionState newState, int suggestionIndex) {
        InternalSuggestionGroup suggestion = new InternalSuggestionGroup.Builder(suggestionGroup).state(newState).appliedIndex(suggestionIndex).build();
        this.dao.update(suggestion);
    }

    private void updateSuggestionStatusInNewTransaction(InternalSuggestionGroup suggestionGroup, SuggestionState newState, int suggestionIndex) {
        this.withNewTransaction.execute(status -> {
            this.updateSuggestionStatus(suggestionGroup, newState, suggestionIndex);
            return null;
        });
    }

    static class PullRequestSuggestionsDisabledException
    extends FeatureDisabledException {
        PullRequestSuggestionsDisabledException(@Nonnull KeyedMessage message) {
            super(message);
        }
    }
}

