/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.comment.LineNumberRange;
import jakarta.annotation.Nonnull;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LineReplacingOutputStream
extends FilterOutputStream {
    private static final int NEWLINE = 10;
    private final LineNumberRange replacementRange;
    private final String replacementText;
    private boolean hasReplaced;
    private int lineCount = 1;

    public LineReplacingOutputStream(@Nonnull OutputStream delegate, LineNumberRange replacementRange, @Nonnull String replacementText) {
        super(new BufferedOutputStream(Objects.requireNonNull(delegate, "delegate")));
        this.replacementRange = replacementRange;
        Objects.requireNonNull(replacementText, "replacementText");
        this.replacementText = replacementText.length() > 1 ? StringUtils.chomp((String)replacementText) : replacementText;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.lineCount > this.replacementRange.maximum()) {
            this.out.write(b);
            return;
        }
        if (this.replacementRange.contains(this.lineCount)) {
            if (!this.hasReplaced) {
                this.out.write(this.replacementText.getBytes(StandardCharsets.UTF_8));
                this.hasReplaced = true;
            }
        } else {
            this.out.write(b);
        }
        if (this.isEOL(b)) {
            if (this.replacementRange.maximum() == this.lineCount && !StringUtils.isBlank((CharSequence)StringUtils.chomp((String)this.replacementText))) {
                this.out.write(b);
            }
            ++this.lineCount;
        }
    }

    private boolean isEOL(int b) {
        return b == 10;
    }
}

