/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.suggestion.SuggestionApplyException;
import com.atlassian.bitbucket.internal.suggestion.SuggestionDriftResult;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.annotation.Value;

public class MultilineSuggestionValidator {
    private final I18nService i18nService;
    private final ScmService scmService;
    @Value(value="${pullrequest.suggestions.drift.timeout}")
    private int driftTimeoutSeconds;
    @Value(value="${page.max.diff.lines}")
    private int maxDiffLines;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;

    public MultilineSuggestionValidator(I18nService i18nService, ScmService scmService) {
        this.i18nService = i18nService;
        this.scmService = scmService;
    }

    @Nonnull
    public SuggestionDriftResult calculateDriftResult(@Nonnull PullRequest pullRequest, @Nonnull CommentThreadDiffAnchor anchor) {
        String sinceId;
        Preconditions.checkArgument((boolean)anchor.isMultilineAnchor(), (Object)"single line comments cannot calculate drift with multiline calculator");
        if (anchor.getMultilineDestinationRange().isPresent() && anchor.getMultilineSourceRange().isEmpty()) {
            sinceId = anchor.getToHash();
        } else {
            if (anchor.getMultilineDestinationRange().isEmpty()) {
                throw this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.invalidremovedline");
            }
            sinceId = (String)anchor.getFromHash().orElseThrow(() -> this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.applyfailed"));
        }
        String untilId = pullRequest.getFromRef().getLatestCommit();
        if (sinceId.equals(untilId)) {
            return new SuggestionDriftResult((LineNumberRange)anchor.getMultilineDestinationRange().get(), anchor.getPath());
        }
        DiffCommandParameters diffParams = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(0)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths(anchor.getPath(), new String[]{anchor.getSrcPath().orElse(null)})).sinceId(sinceId).untilId(untilId).build();
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory(pullRequest.getToRef().getRepository());
        Command diffCommand = commandFactory.diff(diffParams, (DiffContentCallback)new MultilineSuggestionDiffContentCallback((LineNumberRange)anchor.getMultilineSourceRange().get()));
        diffCommand.setTimeout((long)this.driftTimeoutSeconds);
        diffCommand.call();
        return new SuggestionDriftResult((LineNumberRange)anchor.getMultilineDestinationRange().get(), anchor.getPath());
    }

    private SuggestionApplyException suggestionApplyException(String messageKey) {
        return new SuggestionApplyException(this.i18nService.createKeyedMessage(messageKey, new Object[0]));
    }

    private class MultilineSuggestionDiffContentCallback
    extends AbstractDiffContentCallback {
        private final LineNumberRange suggestionSourceLineRange;

        private MultilineSuggestionDiffContentCallback(LineNumberRange suggestionSourceLineRange) {
            this.suggestionSourceLineRange = suggestionSourceLineRange;
        }

        public void onBinary(@Nullable Path src, @Nullable Path dst) {
            throw MultilineSuggestionValidator.this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.applyfailed");
        }

        public void onEnd(@Nonnull DiffSummary summary) {
            if (summary.isTruncated()) {
                throw MultilineSuggestionValidator.this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.applyfailed");
            }
        }

        public void onHunkStart(int deletedLine, int deletedLineSpan, int addedLine, int addedLineSpan, @Nullable String context) {
            LineNumberRange deletedLineRange;
            if (deletedLine > this.suggestionSourceLineRange.maximum()) {
                return;
            }
            if (deletedLineSpan > 0 && (deletedLineRange = new LineNumberRange(deletedLine, deletedLine + deletedLineSpan - 1)).overlaps(this.suggestionSourceLineRange)) {
                throw MultilineSuggestionValidator.this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.invalidremovedline");
            }
        }
    }
}

