/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.event.pull.PullRequestCommentAddRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentModificationRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentReplyRequestedEvent;
import com.atlassian.bitbucket.internal.suggestion.InternalSuggestionService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.event.api.EventListener;

public class SuggestionCommentEventListener {
    private final FeatureManager featureManager;
    private final InternalSuggestionService service;

    public SuggestionCommentEventListener(FeatureManager featureManager, InternalSuggestionService service) {
        this.featureManager = featureManager;
        this.service = service;
    }

    @EventListener
    public void onPullRequestCommentAddRequested(PullRequestCommentAddRequestedEvent event) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_SUGGESTIONS)) {
            this.service.updateCommentSuggestions(event.getComment());
        }
    }

    @EventListener
    public void onPullRequestCommentModificationRequested(PullRequestCommentModificationRequestedEvent event) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_SUGGESTIONS)) {
            this.service.updateCommentSuggestions(event.getComment());
        }
    }

    @EventListener
    public void onPullRequestCommentReplyRequested(PullRequestCommentReplyRequestedEvent event) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_SUGGESTIONS)) {
            this.service.updateCommentSuggestions(event.getComment());
        }
    }
}

