/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.suggestion.SuggestionApplyException;
import com.atlassian.bitbucket.internal.suggestion.SuggestionDriftResult;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.annotation.Value;

public class SuggestionDriftCalculator {
    private final I18nService i18nService;
    private final ScmService scmService;
    @Value(value="${pullrequest.suggestions.drift.timeout}")
    private int driftTimeoutSeconds;
    @Value(value="${page.max.diff.lines}")
    private int maxDiffLines;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;

    public SuggestionDriftCalculator(I18nService i18nService, ScmService scmService) {
        this.i18nService = i18nService;
        this.scmService = scmService;
    }

    public SuggestionDriftResult calculateDriftResult(PullRequest pullRequest, CommentThreadDiffAnchor anchor) {
        String sinceId;
        Preconditions.checkArgument((!anchor.isMultilineAnchor() ? 1 : 0) != 0, (Object)"multiline comments cannot calculate drift with single line drift calculator");
        DiffSegmentType diffSegmentType = (DiffSegmentType)anchor.getLineType().orElseThrow(() -> this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.invalidcommenttype"));
        if (diffSegmentType == DiffSegmentType.ADDED) {
            sinceId = anchor.getToHash();
        } else if (diffSegmentType == DiffSegmentType.CONTEXT) {
            sinceId = (String)anchor.getFromHash().orElseThrow(() -> this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.applyfailed"));
        } else {
            throw this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.invalidremovedline");
        }
        String untilId = pullRequest.getFromRef().getLatestCommit();
        if (untilId.equals(sinceId)) {
            return new SuggestionDriftResult(anchor.getLine(), anchor.getPath());
        }
        DiffCommandParameters diffParams = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(0)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths(anchor.getPath(), new String[]{anchor.getSrcPath().orElse(null)})).sinceId(sinceId).untilId(untilId).build();
        SuggestionDriftCalculatorDiffContentCallback callback = new SuggestionDriftCalculatorDiffContentCallback(anchor.getLine());
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory(pullRequest.getToRef().getRepository());
        Command diffCommand = commandFactory.diff(diffParams, (DiffContentCallback)callback);
        diffCommand.setTimeout((long)this.driftTimeoutSeconds);
        diffCommand.call();
        return new SuggestionDriftResult(anchor.getLine() + callback.getDriftAccumulator(), anchor.getPath());
    }

    private SuggestionApplyException suggestionApplyException(String messageKey) {
        return new SuggestionApplyException(this.i18nService.createKeyedMessage(messageKey, new Object[0]));
    }

    private class SuggestionDriftCalculatorDiffContentCallback
    extends AbstractDiffContentCallback {
        private final int prDiffSuggestionLine;
        private int driftAccumulator;

        private SuggestionDriftCalculatorDiffContentCallback(int prDiffSuggestionLine) {
            this.prDiffSuggestionLine = prDiffSuggestionLine;
        }

        public int getDriftAccumulator() {
            return this.driftAccumulator;
        }

        public void onBinary(@Nullable Path src, @Nullable Path dst) {
            throw SuggestionDriftCalculator.this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.applyfailed");
        }

        public void onEnd(@Nonnull DiffSummary summary) {
            if (summary.isTruncated()) {
                throw SuggestionDriftCalculator.this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.applyfailed");
            }
        }

        public void onHunkStart(int deletedLine, int deletedLineSpan, int addedLine, int addedLineSpan, @Nullable String context) {
            if (deletedLine <= this.prDiffSuggestionLine && deletedLine + deletedLineSpan > this.prDiffSuggestionLine) {
                throw SuggestionDriftCalculator.this.suggestionApplyException("bitbucket.pullrequest.suggestion.apply.linechangedontargetbranch");
            }
            if (deletedLine < this.prDiffSuggestionLine) {
                this.driftAccumulator += addedLineSpan - deletedLineSpan;
            }
        }
    }
}

