/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.internal.suggestion.model.InternalSuggestionGroup;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class ValidSuggestion {
    private final CommentThreadDiffAnchor anchor;
    private final Comment comment;
    private final String suggestion;
    private final InternalSuggestionGroup suggestionGroup;
    private final int suggestionIndex;

    private ValidSuggestion(Builder builder) {
        this.anchor = Objects.requireNonNull(builder.anchor, "anchor");
        this.comment = Objects.requireNonNull(builder.comment, "comment");
        this.suggestion = Objects.requireNonNull(builder.suggestion, "suggestion");
        this.suggestionGroup = Objects.requireNonNull(builder.suggestionGroup, "suggestionGroup");
        this.suggestionIndex = Objects.requireNonNull(builder.suggestionIndex, "suggestionIndex");
    }

    @Nonnull
    public CommentThreadDiffAnchor getAnchor() {
        return this.anchor;
    }

    @Nonnull
    public Comment getComment() {
        return this.comment;
    }

    @Nonnull
    public String getSuggestion() {
        return this.suggestion;
    }

    @Nonnull
    public InternalSuggestionGroup getSuggestionGroup() {
        return this.suggestionGroup;
    }

    public int getSuggestionIndex() {
        return this.suggestionIndex;
    }

    static class Builder
    extends BuilderSupport {
        private CommentThreadDiffAnchor anchor;
        private Comment comment;
        private String suggestion;
        private InternalSuggestionGroup suggestionGroup;
        private Integer suggestionIndex;

        Builder() {
        }

        @Nonnull
        public Builder anchor(@Nonnull CommentThreadDiffAnchor value) {
            this.anchor = Objects.requireNonNull(value, "anchor");
            return this;
        }

        @Nonnull
        ValidSuggestion build() {
            return new ValidSuggestion(this);
        }

        public Builder comment(@Nonnull Comment value) {
            this.comment = Objects.requireNonNull(value, "comment");
            return this;
        }

        @Nonnull
        public Builder suggestion(@Nonnull String value) {
            this.suggestion = Objects.requireNonNull(value, "suggestion");
            return this;
        }

        @Nonnull
        public Builder suggestionGroup(@Nonnull InternalSuggestionGroup value) {
            this.suggestionGroup = Objects.requireNonNull(value, "suggestionGroup");
            return this;
        }

        @Nonnull
        public Builder suggestionIndex(@Nonnull Integer value) {
            this.suggestionIndex = Objects.requireNonNull(value, "suggestionIndex");
            return this;
        }
    }
}

