/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.suggestion.added")
public class SuggestionAddedEvent
extends ApplicationEvent {
    private final Comment comment;
    private final int numberOfSuggestions;
    private final PullRequest pullRequest;

    public SuggestionAddedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, int numberOfSuggestions, @Nonnull Comment comment) {
        super(source);
        this.comment = Objects.requireNonNull(comment, "pullRequest");
        this.numberOfSuggestions = numberOfSuggestions;
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
    }

    @Nonnull
    public Comment getComment() {
        return this.comment;
    }

    public int getNumberOfSuggestions() {
        return this.numberOfSuggestions;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }
}

