/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@EventName(value="stash.pullrequest.suggestion.apply.success")
public class SuggestionApplySuccessfulEvent
extends ApplicationEvent {
    private final int appliedIndex;
    private final Comment comment;
    private final PullRequest pullRequest;

    public SuggestionApplySuccessfulEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull Comment comment, int appliedIndex) {
        super(source);
        this.appliedIndex = appliedIndex;
        this.comment = Objects.requireNonNull(comment, "pullRequest");
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
    }

    public int getAppliedIndex() {
        return this.appliedIndex;
    }

    @Nonnull
    public Comment getComment() {
        return this.comment;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }
}

