/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion.dao;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.internal.suggestion.dao.SuggestionGroupDao;
import com.atlassian.bitbucket.internal.suggestion.model.InternalSuggestionGroup;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;

public class HibernateSuggestionGroupDao
extends AbstractHibernateDao<Long, InternalSuggestionGroup>
implements SuggestionGroupDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = ImmutableList.of((Object)HqlQueryBuilder.HqlQueryOrder.asc((String)"commentId"));

    public HibernateSuggestionGroupDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void deleteByComment(@Nonnull Comment comment) {
        this.deleteById(Long.valueOf(comment.getId()));
    }

    @Override
    @Nonnull
    public Optional<InternalSuggestionGroup> findByComment(@Nonnull Comment comment) {
        return Optional.ofNullable((InternalSuggestionGroup)this.getById(Long.valueOf(comment.getId())));
    }

    @Override
    @Nonnull
    public Set<InternalSuggestionGroup> findByComments(@Nonnull Iterable<Comment> comments) {
        HashSet<InternalSuggestionGroup> result = new HashSet<InternalSuggestionGroup>();
        for (List partition : Iterables.partition(comments, (int)100)) {
            List commentIds = partition.stream().map(Comment::getId).collect(Collectors.toList());
            List suggestionGroups = this.session().createQuery("from InternalSuggestionGroup where commentId in (:commentIds)", InternalSuggestionGroup.class).setParameterList("commentIds", commentIds).list();
            result.addAll(suggestionGroups);
        }
        return result;
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

