/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion.model;

import com.atlassian.bitbucket.dmz.suggestion.SuggestionState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.comment.InternalComment;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_suggestion_group")
public class InternalSuggestionGroup {
    public static final String TABLE = "bb_suggestion_group";
    @Column(name="applied_index")
    private final Integer appliedIndex;
    @Id
    @Column(name="comment_id", nullable=false, unique=true)
    private final long commentId;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.dmz.suggestion.SuggestionState")})
    private final SuggestionState state;

    protected InternalSuggestionGroup() {
        this.appliedIndex = null;
        this.commentId = 0L;
        this.state = null;
    }

    private InternalSuggestionGroup(Builder builder) {
        this.appliedIndex = builder.appliedIndex;
        this.commentId = builder.commentId;
        this.state = builder.state;
    }

    public Integer getAppliedIndex() {
        return this.appliedIndex;
    }

    public long getCommentId() {
        return this.commentId;
    }

    @Nonnull
    public SuggestionState getState() {
        return this.state;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appliedIndex", (Object)this.getAppliedIndex()).add("commentId", this.getCommentId()).add("state", (Object)this.getState()).toString();
    }

    public static class Builder
    extends BuilderSupport {
        private Integer appliedIndex;
        private long commentId;
        private SuggestionState state;

        public Builder(InternalComment comment) {
            this(Objects.requireNonNull(comment, "comment").getId());
        }

        public Builder(long commentId) {
            this.commentId = commentId;
            this.state = SuggestionState.UNAPPLIED;
        }

        public Builder(InternalSuggestionGroup suggestion) {
            this.appliedIndex = suggestion.getAppliedIndex();
            this.commentId = suggestion.getCommentId();
            this.state = suggestion.getState();
        }

        @Nonnull
        public Builder appliedIndex(int appliedIndex) {
            this.appliedIndex = appliedIndex;
            return this;
        }

        @Nonnull
        public InternalSuggestionGroup build() {
            return new InternalSuggestionGroup(this);
        }

        @Nonnull
        public Builder state(@Nonnull SuggestionState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }
    }
}

