/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion.parser;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.function.Predicate;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;

public class CommonMarkSuggestionParser {
    public static final Predicate<Node> IS_SUGGESTION = node -> {
        if (node instanceof FencedCodeBlock) {
            String info = ((FencedCodeBlock)node).getInfo();
            return info != null && "suggestion".equals(info.trim().toLowerCase(Locale.ROOT));
        }
        return false;
    };
    private final Parser parser = Parser.builder().build();

    @Nonnull
    public List<String> parseSuggestions(String text) {
        ImmutableList.Builder suggestions = ImmutableList.builder();
        Node rootNode = this.parser.parse(text);
        Stack<Node> nodeStack = new Stack<Node>();
        nodeStack.push(rootNode);
        while (!nodeStack.isEmpty()) {
            Node node = (Node)nodeStack.pop();
            if (IS_SUGGESTION.test(node)) {
                suggestions.add((Object)((FencedCodeBlock)node).getLiteral());
            }
            for (Node child = node.getLastChild(); child != null; child = child.getPrevious()) {
                nodeStack.push(child);
            }
        }
        return suggestions.build();
    }
}

